# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include marketplacecatalog_service.R
NULL

#' Used to cancel an open change request
#'
#' @description
#' Used to cancel an open change request. Must be sent before the status of the request changes to `APPLYING`, the final stage of completing your change request. You can describe a change during the 60-day request history retention period for API calls.
#'
#' See [https://www.paws-r-sdk.com/docs/marketplacecatalog_cancel_change_set/](https://www.paws-r-sdk.com/docs/marketplacecatalog_cancel_change_set/) for full documentation.
#'
#' @param Catalog &#91;required&#93; Required. The catalog related to the request. Fixed value:
#' `AWSMarketplace`.
#' @param ChangeSetId &#91;required&#93; Required. The unique identifier of the
#' [`start_change_set`][marketplacecatalog_start_change_set] request that
#' you want to cancel.
#'
#' @keywords internal
#'
#' @rdname marketplacecatalog_cancel_change_set
marketplacecatalog_cancel_change_set <- function(Catalog, ChangeSetId) {
  op <- new_operation(
    name = "CancelChangeSet",
    http_method = "PATCH",
    http_path = "/CancelChangeSet",
    paginator = list()
  )
  input <- .marketplacecatalog$cancel_change_set_input(Catalog = Catalog, ChangeSetId = ChangeSetId)
  output <- .marketplacecatalog$cancel_change_set_output()
  config <- get_config()
  svc <- .marketplacecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.marketplacecatalog$operations$cancel_change_set <- marketplacecatalog_cancel_change_set

#' Deletes a resource-based policy on an Entity that is identified by its
#' resource ARN
#'
#' @description
#' Deletes a resource-based policy on an Entity that is identified by its resource ARN.
#'
#' See [https://www.paws-r-sdk.com/docs/marketplacecatalog_delete_resource_policy/](https://www.paws-r-sdk.com/docs/marketplacecatalog_delete_resource_policy/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the Entity resource that is associated
#' with the resource policy.
#'
#' @keywords internal
#'
#' @rdname marketplacecatalog_delete_resource_policy
marketplacecatalog_delete_resource_policy <- function(ResourceArn) {
  op <- new_operation(
    name = "DeleteResourcePolicy",
    http_method = "DELETE",
    http_path = "/DeleteResourcePolicy",
    paginator = list()
  )
  input <- .marketplacecatalog$delete_resource_policy_input(ResourceArn = ResourceArn)
  output <- .marketplacecatalog$delete_resource_policy_output()
  config <- get_config()
  svc <- .marketplacecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.marketplacecatalog$operations$delete_resource_policy <- marketplacecatalog_delete_resource_policy

#' Provides information about a given change set
#'
#' @description
#' Provides information about a given change set.
#'
#' See [https://www.paws-r-sdk.com/docs/marketplacecatalog_describe_change_set/](https://www.paws-r-sdk.com/docs/marketplacecatalog_describe_change_set/) for full documentation.
#'
#' @param Catalog &#91;required&#93; Required. The catalog related to the request. Fixed value:
#' `AWSMarketplace`
#' @param ChangeSetId &#91;required&#93; Required. The unique identifier for the
#' [`start_change_set`][marketplacecatalog_start_change_set] request that
#' you want to describe the details for.
#'
#' @keywords internal
#'
#' @rdname marketplacecatalog_describe_change_set
marketplacecatalog_describe_change_set <- function(Catalog, ChangeSetId) {
  op <- new_operation(
    name = "DescribeChangeSet",
    http_method = "GET",
    http_path = "/DescribeChangeSet",
    paginator = list()
  )
  input <- .marketplacecatalog$describe_change_set_input(Catalog = Catalog, ChangeSetId = ChangeSetId)
  output <- .marketplacecatalog$describe_change_set_output()
  config <- get_config()
  svc <- .marketplacecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.marketplacecatalog$operations$describe_change_set <- marketplacecatalog_describe_change_set

#' Returns the metadata and content of the entity
#'
#' @description
#' Returns the metadata and content of the entity.
#'
#' See [https://www.paws-r-sdk.com/docs/marketplacecatalog_describe_entity/](https://www.paws-r-sdk.com/docs/marketplacecatalog_describe_entity/) for full documentation.
#'
#' @param Catalog &#91;required&#93; Required. The catalog related to the request. Fixed value:
#' `AWSMarketplace`
#' @param EntityId &#91;required&#93; Required. The unique ID of the entity to describe.
#'
#' @keywords internal
#'
#' @rdname marketplacecatalog_describe_entity
marketplacecatalog_describe_entity <- function(Catalog, EntityId) {
  op <- new_operation(
    name = "DescribeEntity",
    http_method = "GET",
    http_path = "/DescribeEntity",
    paginator = list()
  )
  input <- .marketplacecatalog$describe_entity_input(Catalog = Catalog, EntityId = EntityId)
  output <- .marketplacecatalog$describe_entity_output()
  config <- get_config()
  svc <- .marketplacecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.marketplacecatalog$operations$describe_entity <- marketplacecatalog_describe_entity

#' Gets a resource-based policy of an Entity that is identified by its
#' resource ARN
#'
#' @description
#' Gets a resource-based policy of an Entity that is identified by its resource ARN.
#'
#' See [https://www.paws-r-sdk.com/docs/marketplacecatalog_get_resource_policy/](https://www.paws-r-sdk.com/docs/marketplacecatalog_get_resource_policy/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the Entity resource that is associated
#' with the resource policy.
#'
#' @keywords internal
#'
#' @rdname marketplacecatalog_get_resource_policy
marketplacecatalog_get_resource_policy <- function(ResourceArn) {
  op <- new_operation(
    name = "GetResourcePolicy",
    http_method = "GET",
    http_path = "/GetResourcePolicy",
    paginator = list()
  )
  input <- .marketplacecatalog$get_resource_policy_input(ResourceArn = ResourceArn)
  output <- .marketplacecatalog$get_resource_policy_output()
  config <- get_config()
  svc <- .marketplacecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.marketplacecatalog$operations$get_resource_policy <- marketplacecatalog_get_resource_policy

#' Returns the list of change sets owned by the account being used to make
#' the call
#'
#' @description
#' Returns the list of change sets owned by the account being used to make the call. You can filter this list by providing any combination of `entityId`, `ChangeSetName`, and status. If you provide more than one filter, the API operation applies a logical AND between the filters.
#'
#' See [https://www.paws-r-sdk.com/docs/marketplacecatalog_list_change_sets/](https://www.paws-r-sdk.com/docs/marketplacecatalog_list_change_sets/) for full documentation.
#'
#' @param Catalog &#91;required&#93; The catalog related to the request. Fixed value: `AWSMarketplace`
#' @param FilterList An array of filter objects.
#' @param Sort An object that contains two attributes, `SortBy` and `SortOrder`.
#' @param MaxResults The maximum number of results returned by a single call. This value must
#' be provided in the next call to retrieve the next set of results. By
#' default, this value is 20.
#' @param NextToken The token value retrieved from a previous call to access the next page
#' of results.
#'
#' @keywords internal
#'
#' @rdname marketplacecatalog_list_change_sets
marketplacecatalog_list_change_sets <- function(Catalog, FilterList = NULL, Sort = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListChangeSets",
    http_method = "POST",
    http_path = "/ListChangeSets",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "ChangeSetSummaryList")
  )
  input <- .marketplacecatalog$list_change_sets_input(Catalog = Catalog, FilterList = FilterList, Sort = Sort, MaxResults = MaxResults, NextToken = NextToken)
  output <- .marketplacecatalog$list_change_sets_output()
  config <- get_config()
  svc <- .marketplacecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.marketplacecatalog$operations$list_change_sets <- marketplacecatalog_list_change_sets

#' Provides the list of entities of a given type
#'
#' @description
#' Provides the list of entities of a given type.
#'
#' See [https://www.paws-r-sdk.com/docs/marketplacecatalog_list_entities/](https://www.paws-r-sdk.com/docs/marketplacecatalog_list_entities/) for full documentation.
#'
#' @param Catalog &#91;required&#93; The catalog related to the request. Fixed value: `AWSMarketplace`
#' @param EntityType &#91;required&#93; The type of entities to retrieve.
#' @param FilterList An array of filter objects. Each filter object contains two attributes,
#' `filterName` and `filterValues`.
#' @param Sort An object that contains two attributes, `SortBy` and `SortOrder`.
#' @param NextToken The value of the next token, if it exists. Null if there are no more
#' results.
#' @param MaxResults Specifies the upper limit of the elements on a single page. If a value
#' isn't provided, the default value is 20.
#' @param OwnershipType 
#'
#' @keywords internal
#'
#' @rdname marketplacecatalog_list_entities
marketplacecatalog_list_entities <- function(Catalog, EntityType, FilterList = NULL, Sort = NULL, NextToken = NULL, MaxResults = NULL, OwnershipType = NULL) {
  op <- new_operation(
    name = "ListEntities",
    http_method = "POST",
    http_path = "/ListEntities",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "EntitySummaryList")
  )
  input <- .marketplacecatalog$list_entities_input(Catalog = Catalog, EntityType = EntityType, FilterList = FilterList, Sort = Sort, NextToken = NextToken, MaxResults = MaxResults, OwnershipType = OwnershipType)
  output <- .marketplacecatalog$list_entities_output()
  config <- get_config()
  svc <- .marketplacecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.marketplacecatalog$operations$list_entities <- marketplacecatalog_list_entities

#' Lists all tags that have been added to a resource (either an entity or
#' change set)
#'
#' @description
#' Lists all tags that have been added to a resource (either an [entity](https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html#catalog-api-entities) or [change set](https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html#working-with-change-sets)).
#'
#' See [https://www.paws-r-sdk.com/docs/marketplacecatalog_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/marketplacecatalog_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; Required. The Amazon Resource Name (ARN) associated with the resource
#' you want to list tags on.
#'
#' @keywords internal
#'
#' @rdname marketplacecatalog_list_tags_for_resource
marketplacecatalog_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/ListTagsForResource",
    paginator = list()
  )
  input <- .marketplacecatalog$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .marketplacecatalog$list_tags_for_resource_output()
  config <- get_config()
  svc <- .marketplacecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.marketplacecatalog$operations$list_tags_for_resource <- marketplacecatalog_list_tags_for_resource

#' Attaches a resource-based policy to an Entity
#'
#' @description
#' Attaches a resource-based policy to an Entity. Examples of an entity include: `AmiProduct` and `ContainerProduct`.
#'
#' See [https://www.paws-r-sdk.com/docs/marketplacecatalog_put_resource_policy/](https://www.paws-r-sdk.com/docs/marketplacecatalog_put_resource_policy/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the Entity resource you want to
#' associate with a resource policy.
#' @param Policy &#91;required&#93; The policy document to set; formatted in JSON.
#'
#' @keywords internal
#'
#' @rdname marketplacecatalog_put_resource_policy
marketplacecatalog_put_resource_policy <- function(ResourceArn, Policy) {
  op <- new_operation(
    name = "PutResourcePolicy",
    http_method = "POST",
    http_path = "/PutResourcePolicy",
    paginator = list()
  )
  input <- .marketplacecatalog$put_resource_policy_input(ResourceArn = ResourceArn, Policy = Policy)
  output <- .marketplacecatalog$put_resource_policy_output()
  config <- get_config()
  svc <- .marketplacecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.marketplacecatalog$operations$put_resource_policy <- marketplacecatalog_put_resource_policy

#' Allows you to request changes for your entities
#'
#' @description
#' Allows you to request changes for your entities. Within a single `ChangeSet`, you can't start the same change type against the same entity multiple times. Additionally, when a `ChangeSet` is running, all the entities targeted by the different changes are locked until the change set has completed (either succeeded, cancelled, or failed). If you try to start a change set containing a change against an entity that is already locked, you will receive a `ResourceInUseException` error.
#'
#' See [https://www.paws-r-sdk.com/docs/marketplacecatalog_start_change_set/](https://www.paws-r-sdk.com/docs/marketplacecatalog_start_change_set/) for full documentation.
#'
#' @param Catalog &#91;required&#93; The catalog related to the request. Fixed value: `AWSMarketplace`
#' @param ChangeSet &#91;required&#93; Array of `change` object.
#' @param ChangeSetName Optional case sensitive string of up to 100 ASCII characters. The change
#' set name can be used to filter the list of change sets.
#' @param ClientRequestToken A unique token to identify the request to ensure idempotency.
#' @param ChangeSetTags A list of objects specifying each key name and value for the
#' `ChangeSetTags` property.
#'
#' @keywords internal
#'
#' @rdname marketplacecatalog_start_change_set
marketplacecatalog_start_change_set <- function(Catalog, ChangeSet, ChangeSetName = NULL, ClientRequestToken = NULL, ChangeSetTags = NULL) {
  op <- new_operation(
    name = "StartChangeSet",
    http_method = "POST",
    http_path = "/StartChangeSet",
    paginator = list()
  )
  input <- .marketplacecatalog$start_change_set_input(Catalog = Catalog, ChangeSet = ChangeSet, ChangeSetName = ChangeSetName, ClientRequestToken = ClientRequestToken, ChangeSetTags = ChangeSetTags)
  output <- .marketplacecatalog$start_change_set_output()
  config <- get_config()
  svc <- .marketplacecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.marketplacecatalog$operations$start_change_set <- marketplacecatalog_start_change_set

#' Tags a resource (either an entity or change set)
#'
#' @description
#' Tags a resource (either an [entity](https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html#catalog-api-entities) or [change set](https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html#working-with-change-sets)).
#'
#' See [https://www.paws-r-sdk.com/docs/marketplacecatalog_tag_resource/](https://www.paws-r-sdk.com/docs/marketplacecatalog_tag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; Required. The Amazon Resource Name (ARN) associated with the resource
#' you want to tag.
#' @param Tags &#91;required&#93; Required. A list of objects specifying each key name and value. Number
#' of objects allowed: 1-50.
#'
#' @keywords internal
#'
#' @rdname marketplacecatalog_tag_resource
marketplacecatalog_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/TagResource",
    paginator = list()
  )
  input <- .marketplacecatalog$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .marketplacecatalog$tag_resource_output()
  config <- get_config()
  svc <- .marketplacecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.marketplacecatalog$operations$tag_resource <- marketplacecatalog_tag_resource

#' Removes a tag or list of tags from a resource (either an entity or
#' change set)
#'
#' @description
#' Removes a tag or list of tags from a resource (either an [entity](https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html#catalog-api-entities) or [change set](https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html#working-with-change-sets)).
#'
#' See [https://www.paws-r-sdk.com/docs/marketplacecatalog_untag_resource/](https://www.paws-r-sdk.com/docs/marketplacecatalog_untag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; Required. The Amazon Resource Name (ARN) associated with the resource
#' you want to remove the tag from.
#' @param TagKeys &#91;required&#93; Required. A list of key names of tags to be removed. Number of strings
#' allowed: 0-256.
#'
#' @keywords internal
#'
#' @rdname marketplacecatalog_untag_resource
marketplacecatalog_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/UntagResource",
    paginator = list()
  )
  input <- .marketplacecatalog$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .marketplacecatalog$untag_resource_output()
  config <- get_config()
  svc <- .marketplacecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.marketplacecatalog$operations$untag_resource <- marketplacecatalog_untag_resource
