% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/costexplorer_operations.R
\name{costexplorer_update_cost_category_definition}
\alias{costexplorer_update_cost_category_definition}
\title{Updates an existing Cost Category}
\usage{
costexplorer_update_cost_category_definition(
  CostCategoryArn,
  RuleVersion,
  Rules,
  DefaultValue = NULL,
  SplitChargeRules = NULL
)
}
\arguments{
\item{CostCategoryArn}{[required] The unique identifier for your Cost Category.}

\item{RuleVersion}{[required]}

\item{Rules}{[required] The \code{Expression} object used to categorize costs. For more information,
see
\href{https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostCategoryRule.html}{CostCategoryRule}
.}

\item{DefaultValue}{}

\item{SplitChargeRules}{The split charge rules used to allocate your charges between your Cost
Category values.}
}
\description{
Updates an existing Cost Category. Changes made to the Cost Category rules will be used to categorize the current month’s expenses and future expenses. This won’t change categorization for the previous months.

See \url{https://paws-r.github.io/docs/costexplorer/update_cost_category_definition.html} for full documentation.
}
\keyword{internal}
