% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marketplacemetering_service.R
\name{marketplacemetering}
\alias{marketplacemetering}
\title{AWSMarketplace Metering}
\usage{
marketplacemetering(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
AWS Marketplace Metering Service

This reference provides descriptions of the low-level AWS Marketplace
Metering Service API.

AWS Marketplace sellers can use this API to submit usage data for custom
usage dimensions.

For information on the permissions you need to use this API, see \href{https://docs.aws.amazon.com/marketplace/latest/userguide/iam-user-policy-for-aws-marketplace-actions.html}{AWS Marketing metering and entitlement API permissions}
in the \emph{AWS Marketplace Seller Guide.}

\strong{Submitting Metering Records}
\itemize{
\item \emph{MeterUsage}- Submits the metering record for a Marketplace product.
MeterUsage is called from an EC2 instance or a container running on
EKS or ECS.
\item \emph{BatchMeterUsage}- Submits the metering record for a set of
customers. BatchMeterUsage is called from a software-as-a-service
(SaaS) application.
}

\strong{Accepting New Customers}
\itemize{
\item \emph{ResolveCustomer}- Called by a SaaS application during the
registration process. When a buyer visits your website during the
registration process, the buyer submits a Registration Token through
the browser. The Registration Token is resolved through this API to
obtain a CustomerIdentifier and Product Code.
}

\strong{Entitlement and Metering for Paid Container Products}
\itemize{
\item Paid container software products sold through AWS Marketplace must
integrate with the AWS Marketplace Metering Service and call the
RegisterUsage operation for software entitlement and metering. Free
and BYOL products for Amazon ECS or Amazon EKS aren't required to
call RegisterUsage, but you can do so if you want to receive usage
data in your seller reports. For more information on using the
RegisterUsage operation, see \href{https://docs.aws.amazon.com/marketplace/latest/userguide/container-based-products.html}{Container-Based Products}.
}

BatchMeterUsage API calls are captured by AWS CloudTrail. You can use
Cloudtrail to verify that the SaaS metering records that you sent are
accurate by searching for records with the eventName of BatchMeterUsage.
You can also use CloudTrail to audit records over time. For more
information, see the \emph{\href{https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html}{AWS CloudTrail User Guide}}
.
}
\section{Service syntax}{
\preformatted{svc <- marketplacemetering(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string"
    ),
    endpoint = "string",
    region = "string"
  )
)
}
}

\section{Operations}{

\tabular{ll}{
\link[=marketplacemetering_batch_meter_usage]{batch_meter_usage} \tab BatchMeterUsage is called from a SaaS application listed on the AWS Marketplace to post metering records for a set of customers\cr
\link[=marketplacemetering_meter_usage]{meter_usage} \tab API to emit metering records\cr
\link[=marketplacemetering_register_usage]{register_usage} \tab Paid container software products sold through AWS Marketplace must integrate with the AWS Marketplace Metering Service and call the RegisterUsage operation for software entitlement and metering\cr
\link[=marketplacemetering_resolve_customer]{resolve_customer} \tab ResolveCustomer is called by a SaaS application during the registration process
}
}

\examples{
\dontrun{
svc <- marketplacemetering()
svc$batch_meter_usage(
  Foo = 123
)
}

}
