% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_update_event_source_mapping}
\alias{lambda_update_event_source_mapping}
\title{Updates an event source mapping}
\usage{
lambda_update_event_source_mapping(
  UUID,
  FunctionName = NULL,
  Enabled = NULL,
  BatchSize = NULL,
  FilterCriteria = NULL,
  MaximumBatchingWindowInSeconds = NULL,
  DestinationConfig = NULL,
  MaximumRecordAgeInSeconds = NULL,
  BisectBatchOnFunctionError = NULL,
  MaximumRetryAttempts = NULL,
  ParallelizationFactor = NULL,
  SourceAccessConfigurations = NULL,
  TumblingWindowInSeconds = NULL,
  FunctionResponseTypes = NULL,
  ScalingConfig = NULL,
  DocumentDBEventSourceConfig = NULL,
  KMSKeyArn = NULL,
  MetricsConfig = NULL,
  ProvisionedPollerConfig = NULL
)
}
\arguments{
\item{UUID}{[required] The identifier of the event source mapping.}

\item{FunctionName}{The name or ARN of the Lambda function.

\strong{Name formats}
\itemize{
\item \strong{Function name} – \code{MyFunction}.
\item \strong{Function ARN} –
\verb{arn:aws:lambda:us-west-2:123456789012:function:MyFunction}.
\item \strong{Version or Alias ARN} –
\verb{arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD}.
\item \strong{Partial ARN} – \verb{123456789012:function:MyFunction}.
}

The length constraint applies only to the full ARN. If you specify only
the function name, it's limited to 64 characters in length.}

\item{Enabled}{When true, the event source mapping is active. When false, Lambda pauses
polling and invocation.

Default: True}

\item{BatchSize}{The maximum number of records in each batch that Lambda pulls from your
stream or queue and sends to your function. Lambda passes all of the
records in the batch to the function in a single call, up to the payload
limit for synchronous invocation (6 MB).
\itemize{
\item \strong{Amazon Kinesis} – Default 100. Max 10,000.
\item \strong{Amazon DynamoDB Streams} – Default 100. Max 10,000.
\item \strong{Amazon Simple Queue Service} – Default 10. For standard queues
the max is 10,000. For FIFO queues the max is 10.
\item \strong{Amazon Managed Streaming for Apache Kafka} – Default 100. Max
10,000.
\item \strong{Self-managed Apache Kafka} – Default 100. Max 10,000.
\item \strong{Amazon MQ (ActiveMQ and RabbitMQ)} – Default 100. Max 10,000.
\item \strong{DocumentDB} – Default 100. Max 10,000.
}}

\item{FilterCriteria}{An object that defines the filter criteria that determine whether Lambda
should process an event. For more information, see \href{https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html}{Lambda event filtering}.}

\item{MaximumBatchingWindowInSeconds}{The maximum amount of time, in seconds, that Lambda spends gathering
records before invoking the function. You can configure
\code{MaximumBatchingWindowInSeconds} to any value from 0 seconds to 300
seconds in increments of seconds.

For Kinesis, DynamoDB, and Amazon SQS event sources, the default
batching window is 0 seconds. For Amazon MSK, Self-managed Apache Kafka,
Amazon MQ, and DocumentDB event sources, the default batching window is
500 ms. Note that because you can only change
\code{MaximumBatchingWindowInSeconds} in increments of seconds, you cannot
revert back to the 500 ms default batching window after you have changed
it. To restore the default batching window, you must create a new event
source mapping.

Related setting: For Kinesis, DynamoDB, and Amazon SQS event sources,
when you set \code{BatchSize} to a value greater than 10, you must set
\code{MaximumBatchingWindowInSeconds} to at least 1.}

\item{DestinationConfig}{(Kinesis, DynamoDB Streams, Amazon MSK, and self-managed Kafka only) A
configuration object that specifies the destination of an event after
Lambda processes it.}

\item{MaximumRecordAgeInSeconds}{(Kinesis and DynamoDB Streams only) Discard records older than the
specified age. The default value is infinite (-1).}

\item{BisectBatchOnFunctionError}{(Kinesis and DynamoDB Streams only) If the function returns an error,
split the batch in two and retry.}

\item{MaximumRetryAttempts}{(Kinesis and DynamoDB Streams only) Discard records after the specified
number of retries. The default value is infinite (-1). When set to
infinite (-1), failed records are retried until the record expires.}

\item{ParallelizationFactor}{(Kinesis and DynamoDB Streams only) The number of batches to process
from each shard concurrently.}

\item{SourceAccessConfigurations}{An array of authentication protocols or VPC components required to
secure your event source.}

\item{TumblingWindowInSeconds}{(Kinesis and DynamoDB Streams only) The duration in seconds of a
processing window for DynamoDB and Kinesis Streams event sources. A
value of 0 seconds indicates no tumbling window.}

\item{FunctionResponseTypes}{(Kinesis, DynamoDB Streams, and Amazon SQS) A list of current response
type enums applied to the event source mapping.}

\item{ScalingConfig}{(Amazon SQS only) The scaling configuration for the event source. For
more information, see \href{https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-max-concurrency}{Configuring maximum concurrency for Amazon SQS event sources}.}

\item{DocumentDBEventSourceConfig}{Specific configuration settings for a DocumentDB event source.}

\item{KMSKeyArn}{The ARN of the Key Management Service (KMS) customer managed key that
Lambda uses to encrypt your function's \href{https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html#filtering-basics}{filter criteria}.
By default, Lambda does not encrypt your filter criteria object. Specify
this property to encrypt data using your own customer managed key.}

\item{MetricsConfig}{The metrics configuration for your event source. For more information,
see \href{https://docs.aws.amazon.com/lambda/latest/dg/monitoring-metrics-types.html#event-source-mapping-metrics}{Event source mapping metrics}.}

\item{ProvisionedPollerConfig}{(Amazon MSK and self-managed Apache Kafka only) The Provisioned Mode
configuration for the event source. For more information, see
\href{https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventsourcemapping.html#invocation-eventsourcemapping-provisioned-mode}{Provisioned Mode}.}
}
\description{
Updates an event source mapping. You can change the function that Lambda invokes, or pause invocation and resume later from the same location.

See \url{https://www.paws-r-sdk.com/docs/lambda_update_event_source_mapping/} for full documentation.
}
\keyword{internal}
