% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_disassociate_capacity_reservation_billing_owner}
\alias{ec2_disassociate_capacity_reservation_billing_owner}
\title{Cancels a pending request to assign billing of the unused capacity of a
Capacity Reservation to a consumer account, or revokes a request that
has already been accepted}
\usage{
ec2_disassociate_capacity_reservation_billing_owner(
  DryRun = NULL,
  CapacityReservationId,
  UnusedReservationBillingOwnerId
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{CapacityReservationId}{[required] The ID of the Capacity Reservation.}

\item{UnusedReservationBillingOwnerId}{[required] The ID of the consumer account to which the request was sent.}
}
\description{
Cancels a pending request to assign billing of the unused capacity of a Capacity Reservation to a consumer account, or revokes a request that has already been accepted. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/assign-billing.html}{Billing assignment for shared Amazon EC2 Capacity Reservations}.

See \url{https://www.paws-r-sdk.com/docs/ec2_disassociate_capacity_reservation_billing_owner/} for full documentation.
}
\keyword{internal}
