% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proton_operations.R
\name{proton_update_component}
\alias{proton_update_component}
\title{Update a component}
\usage{
proton_update_component(
  deploymentType,
  description = NULL,
  name,
  serviceInstanceName = NULL,
  serviceName = NULL,
  serviceSpec = NULL,
  templateFile = NULL
)
}
\arguments{
\item{deploymentType}{[required] The deployment type. It defines the mode for updating a component, as
follows:

\code{NONE}

In this mode, a deployment \emph{doesn't} occur. Only the requested metadata
parameters are updated. You can only specify \code{description} in this mode.

\code{CURRENT_VERSION}

In this mode, the component is deployed and updated with the new
\code{serviceSpec}, \code{templateSource}, and/or \code{type} that you provide. Only
requested parameters are updated.}

\item{description}{An optional customer-provided description of the component.}

\item{name}{[required] The name of the component to update.}

\item{serviceInstanceName}{The name of the service instance that you want to attach this component
to. Don't specify to keep the component's current service instance
attachment. Specify an empty string to detach the component from the
service instance it's attached to. Specify non-empty values for both
\code{serviceInstanceName} and \code{serviceName} or for neither of them.}

\item{serviceName}{The name of the service that \code{serviceInstanceName} is associated with.
Don't specify to keep the component's current service instance
attachment. Specify an empty string to detach the component from the
service instance it's attached to. Specify non-empty values for both
\code{serviceInstanceName} and \code{serviceName} or for neither of them.}

\item{serviceSpec}{The service spec that you want the component to use to access service
inputs. Set this only when the component is attached to a service
instance.}

\item{templateFile}{A path to the Infrastructure as Code (IaC) file describing
infrastructure that a custom component provisions.

Components support a single IaC file, even if you use Terraform as your
template language.}
}
\description{
Update a component.

See \url{https://paws-r.github.io/docs/proton/update_component.html} for full documentation.
}
\keyword{internal}
