% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proton_operations.R
\name{proton_create_service_template}
\alias{proton_create_service_template}
\title{Create a service template}
\usage{
proton_create_service_template(
  description = NULL,
  displayName = NULL,
  encryptionKey = NULL,
  name,
  pipelineProvisioning = NULL,
  tags = NULL
)
}
\arguments{
\item{description}{A description of the service template.}

\item{displayName}{The name of the service template as displayed in the developer
interface.}

\item{encryptionKey}{A customer provided encryption key that's used to encrypt data.}

\item{name}{[required] The name of the service template.}

\item{pipelineProvisioning}{By default, Proton provides a service pipeline for your service. When
this parameter is included, it indicates that an Proton service pipeline
\emph{isn't} provided for your service. After it's included, it \emph{can't} be
changed. For more information, see \href{https://docs.aws.amazon.com/proton/latest/userguide/ag-template-authoring.html#ag-template-bundles}{Service template bundles}
in the \emph{Proton Administrator Guide}.}

\item{tags}{An optional list of metadata items that you can associate with the
Proton service template. A tag is a key-value pair.

For more information, see \emph{Proton resources and tagging} in the \href{https://docs.aws.amazon.com/proton/latest/userguide/resources.html}{Proton Administrator Guide}
or \href{https://docs.aws.amazon.com/proton/latest/userguide/resources.html}{Proton User Guide}.}
}
\description{
Create a service template. The administrator creates a service template to define standardized infrastructure and an optional CI/CD service pipeline. Developers, in turn, select the service template from Proton. If the selected service template includes a service pipeline definition, they provide a link to their source code repository. Proton then deploys and manages the infrastructure defined by the selected service template. For more information, see \href{https://docs.aws.amazon.com/proton/latest/userguide/ag-templates.html}{Service Templates} in the \emph{Proton Administrator Guide}.

See \url{https://paws-r.github.io/docs/proton/create_service_template.html} for full documentation.
}
\keyword{internal}
