% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs_operations.R
\name{ecs_register_container_instance}
\alias{ecs_register_container_instance}
\title{This action is only used by the Amazon ECS agent, and it is not intended
for use outside of the agent}
\usage{
ecs_register_container_instance(
  cluster = NULL,
  instanceIdentityDocument = NULL,
  instanceIdentityDocumentSignature = NULL,
  totalResources = NULL,
  versionInfo = NULL,
  containerInstanceArn = NULL,
  attributes = NULL,
  platformDevices = NULL,
  tags = NULL
)
}
\arguments{
\item{cluster}{The short name or full Amazon Resource Name (ARN) of the cluster to
register your container instance with. If you do not specify a cluster,
the default cluster is assumed.}

\item{instanceIdentityDocument}{The instance identity document for the EC2 instance to register. This
document can be found by running the following command from the
instance:
\verb{curl http://169.254.169.254/latest/dynamic/instance-identity/document/}}

\item{instanceIdentityDocumentSignature}{The instance identity document signature for the EC2 instance to
register. This signature can be found by running the following command
from the instance:
\verb{curl http://169.254.169.254/latest/dynamic/instance-identity/signature/}}

\item{totalResources}{The resources available on the instance.}

\item{versionInfo}{The version information for the Amazon ECS container agent and Docker
daemon that runs on the container instance.}

\item{containerInstanceArn}{The ARN of the container instance (if it was previously registered).}

\item{attributes}{The container instance attributes that this container instance supports.}

\item{platformDevices}{The devices that are available on the container instance. The only
supported device type is a GPU.}

\item{tags}{The metadata that you apply to the container instance to help you
categorize and organize them. Each tag consists of a key and an optional
value. You define both.

The following basic restrictions apply to tags:
\itemize{
\item Maximum number of tags per resource - 50
\item For each resource, each tag key must be unique, and each tag key can
have only one value.
\item Maximum key length - 128 Unicode characters in UTF-8
\item Maximum value length - 256 Unicode characters in UTF-8
\item If your tagging schema is used across multiple services and
resources, remember that other services may have restrictions on
allowed characters. Generally allowed characters are: letters,
numbers, and spaces representable in UTF-8, and the following
characters: + - = . _ : / @.
\item Tag keys and values are case-sensitive.
\item Do not use \verb{aws:}, \verb{AWS:}, or any upper or lowercase combination of
such as a prefix for either keys or values as it is reserved for
Amazon Web Services use. You cannot edit or delete tag keys or
values with this prefix. Tags with this prefix do not count against
your tags per resource limit.
}}
}
\description{
This action is only used by the Amazon ECS agent, and it is not intended for use outside of the agent.

See \url{https://paws-r.github.io/docs/ecs/register_container_instance.html} for full documentation.
}
\keyword{internal}
