% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_replace_transit_gateway_route}
\alias{ec2_replace_transit_gateway_route}
\title{Replaces the specified route in the specified transit gateway route
table}
\usage{
ec2_replace_transit_gateway_route(
  DestinationCidrBlock,
  TransitGatewayRouteTableId,
  TransitGatewayAttachmentId = NULL,
  Blackhole = NULL,
  DryRun = NULL
)
}
\arguments{
\item{DestinationCidrBlock}{[required] The CIDR range used for the destination match. Routing decisions are
based on the most specific match.}

\item{TransitGatewayRouteTableId}{[required] The ID of the route table.}

\item{TransitGatewayAttachmentId}{The ID of the attachment.}

\item{Blackhole}{Indicates whether traffic matching this route is to be dropped.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Replaces the specified route in the specified transit gateway route table.

See \url{https://paws-r.github.io/docs/ec2/replace_transit_gateway_route.html} for full documentation.
}
\keyword{internal}
