% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/braket_operations.R
\name{braket_create_job}
\alias{braket_create_job}
\title{Creates an Amazon Braket job}
\usage{
braket_create_job(
  algorithmSpecification,
  checkpointConfig = NULL,
  clientToken,
  deviceConfig,
  hyperParameters = NULL,
  inputDataConfig = NULL,
  instanceConfig,
  jobName,
  outputDataConfig,
  roleArn,
  stoppingCondition = NULL,
  tags = NULL
)
}
\arguments{
\item{algorithmSpecification}{[required] Definition of the Amazon Braket job to be created. Specifies the
container image the job uses and information about the Python scripts
used for entry and training.}

\item{checkpointConfig}{Information about the output locations for job checkpoint data.}

\item{clientToken}{[required] A unique token that guarantees that the call to this API is idempotent.}

\item{deviceConfig}{[required] The quantum processing unit (QPU) or simulator used to create an Amazon
Braket job.}

\item{hyperParameters}{Algorithm-specific parameters used by an Amazon Braket job that
influence the quality of the training job. The values are set with a
string of JSON key:value pairs, where the key is the name of the
hyperparameter and the value is the value of th hyperparameter.}

\item{inputDataConfig}{A list of parameters that specify the name and type of input data and
where it is located.}

\item{instanceConfig}{[required] Configuration of the resource instances to use while running the hybrid
job on Amazon Braket.}

\item{jobName}{[required] The name of the Amazon Braket job.}

\item{outputDataConfig}{[required] The path to the S3 location where you want to store job artifacts and
the encryption key used to store them.}

\item{roleArn}{[required] The Amazon Resource Name (ARN) of an IAM role that Amazon Braket can
assume to perform tasks on behalf of a user. It can access user
resources, run an Amazon Braket job container on behalf of user, and
output resources to the users' s3 buckets.}

\item{stoppingCondition}{The user-defined criteria that specifies when a job stops running.}

\item{tags}{A tag object that consists of a key and an optional value, used to
manage metadata for Amazon Braket resources.}
}
\description{
Creates an Amazon Braket job.

See \url{https://paws-r.github.io/docs/braket/create_job.html} for full documentation.
}
\keyword{internal}
