% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_scheduled_instance_availability}
\alias{ec2_describe_scheduled_instance_availability}
\title{Finds available schedules that meet the specified criteria}
\usage{
ec2_describe_scheduled_instance_availability(DryRun, Filters,
  FirstSlotStartTimeRange, MaxResults, MaxSlotDurationInHours,
  MinSlotDurationInHours, NextToken, Recurrence)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{Filters}{The filters.
\itemize{
\item \code{availability-zone} - The Availability Zone (for example,
\verb{us-west-2a}).
\item \code{instance-type} - The instance type (for example, \code{c4.large}).
\item \code{network-platform} - The network platform (\code{EC2-Classic} or
\code{EC2-VPC}).
\item \code{platform} - The platform (\code{Linux/UNIX} or \code{Windows}).
}}

\item{FirstSlotStartTimeRange}{[required] The time period for the first schedule to start.}

\item{MaxResults}{The maximum number of results to return in a single call. This value can
be between 5 and 300. The default value is 300. To retrieve the
remaining results, make another call with the returned \code{NextToken}
value.}

\item{MaxSlotDurationInHours}{The maximum available duration, in hours. This value must be greater
than \code{MinSlotDurationInHours} and less than 1,720.}

\item{MinSlotDurationInHours}{The minimum available duration, in hours. The minimum required duration
is 1,200 hours per year. For example, the minimum daily schedule is 4
hours, the minimum weekly schedule is 24 hours, and the minimum monthly
schedule is 100 hours.}

\item{NextToken}{The token for the next set of results.}

\item{Recurrence}{[required] The schedule recurrence.}
}
\description{
Finds available schedules that meet the specified criteria.
}
\details{
You can search for an available schedule no more than 3 months in
advance. You must meet the minimum required duration of 1,200 hours per
year. For example, the minimum daily schedule is 4 hours, the minimum
weekly schedule is 24 hours, and the minimum monthly schedule is 100
hours.

After you find a schedule that meets your needs, call
PurchaseScheduledInstances to purchase Scheduled Instances with that
schedule.
}
\section{Request syntax}{
\preformatted{svc$describe_scheduled_instance_availability(
  DryRun = TRUE|FALSE,
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  FirstSlotStartTimeRange = list(
    EarliestTime = as.POSIXct(
      "2015-01-01"
    ),
    LatestTime = as.POSIXct(
      "2015-01-01"
    )
  ),
  MaxResults = 123,
  MaxSlotDurationInHours = 123,
  MinSlotDurationInHours = 123,
  NextToken = "string",
  Recurrence = list(
    Frequency = "string",
    Interval = 123,
    OccurrenceDays = list(
      123
    ),
    OccurrenceRelativeToEnd = TRUE|FALSE,
    OccurrenceUnit = "string"
  )
)
}
}

\examples{
# This example describes a schedule that occurs every week on Sunday,
# starting on the specified date. Note that the output contains a single
# schedule as an example.
\dontrun{svc$describe_scheduled_instance_availability(
  FirstSlotStartTimeRange = list(
    EarliestTime = "2016-01-31T00:00:00Z",
    LatestTime = "2016-01-31T04:00:00Z"
  ),
  Recurrence = list(
    Frequency = "Weekly",
    Interval = 1L,
    OccurrenceDays = list(
      1L
    )
  )
)}

}
\keyword{internal}
