% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_delete_route}
\alias{ec2_delete_route}
\title{Deletes the specified route from the specified route table}
\usage{
ec2_delete_route(DestinationCidrBlock, DestinationIpv6CidrBlock, DryRun,
  RouteTableId)
}
\arguments{
\item{DestinationCidrBlock}{The IPv4 CIDR range for the route. The value you specify must match the
CIDR for the route exactly.}

\item{DestinationIpv6CidrBlock}{The IPv6 CIDR range for the route. The value you specify must match the
CIDR for the route exactly.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{RouteTableId}{[required] The ID of the route table.}
}
\description{
Deletes the specified route from the specified route table.
}
\section{Request syntax}{
\preformatted{svc$delete_route(
  DestinationCidrBlock = "string",
  DestinationIpv6CidrBlock = "string",
  DryRun = TRUE|FALSE,
  RouteTableId = "string"
)
}
}

\examples{
# This example deletes the specified route from the specified route table.
\dontrun{svc$delete_route(
  DestinationCidrBlock = "0.0.0.0/0",
  RouteTableId = "rtb-22574640"
)}

}
\keyword{internal}
