% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_get_relational_database_snapshot}
\alias{lightsail_get_relational_database_snapshot}
\title{Returns information about a specific database snapshot in Amazon
Lightsail}
\usage{
lightsail_get_relational_database_snapshot(
  relationalDatabaseSnapshotName)
}
\arguments{
\item{relationalDatabaseSnapshotName}{[required] The name of the database snapshot for which to get information.}
}
\value{
A list with the following syntax:\preformatted{list(
  relationalDatabaseSnapshot = list(
    name = "string",
    arn = "string",
    supportCode = "string",
    createdAt = as.POSIXct(
      "2015-01-01"
    ),
    location = list(
      availabilityZone = "string",
      regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
    ),
    resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
    tags = list(
      list(
        key = "string",
        value = "string"
      )
    ),
    engine = "string",
    engineVersion = "string",
    sizeInGb = 123,
    state = "string",
    fromRelationalDatabaseName = "string",
    fromRelationalDatabaseArn = "string",
    fromRelationalDatabaseBundleId = "string",
    fromRelationalDatabaseBlueprintId = "string"
  )
)
}
}
\description{
Returns information about a specific database snapshot in Amazon
Lightsail.
}
\section{Request syntax}{
\preformatted{svc$get_relational_database_snapshot(
  relationalDatabaseSnapshotName = "string"
)
}
}

\keyword{internal}
