% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/serverlessapplicationrepository_operations.R
\name{serverlessapplicationrepository_list_application_versions}
\alias{serverlessapplicationrepository_list_application_versions}
\title{Lists versions for the specified application}
\usage{
serverlessapplicationrepository_list_application_versions(ApplicationId,
  MaxItems, NextToken)
}
\arguments{
\item{ApplicationId}{[required] The Amazon Resource Name (ARN) of the application.}

\item{MaxItems}{The total number of items to return.}

\item{NextToken}{A token to specify where to start paginating.}
}
\value{
A list with the following syntax:\preformatted{list(
  NextToken = "string",
  Versions = list(
    list(
      ApplicationId = "string",
      CreationTime = "string",
      SemanticVersion = "string",
      SourceCodeUrl = "string"
    )
  )
)
}
}
\description{
Lists versions for the specified application.
}
\section{Request syntax}{
\preformatted{svc$list_application_versions(
  ApplicationId = "string",
  MaxItems = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
