% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_delete_container_image}
\alias{lightsail_delete_container_image}
\title{Deletes a container image that is registered to your Amazon Lightsail
container service}
\usage{
lightsail_delete_container_image(serviceName, image)
}
\arguments{
\item{serviceName}{[required] The name of the container service for which to delete a registered
container image.}

\item{image}{[required] The name of the container image to delete from the container service.

Use the \code{\link[=lightsail_get_container_images]{get_container_images}} action
to get the name of the container images that are registered to a
container service.

Container images sourced from your Lightsail container service, that are
registered and stored on your service, start with a colon (\code{:}). For
example, \verb{:container-service-1.mystaticwebsite.1}. Container images
sourced from a public registry like Docker Hub don't start with a colon.
For example, \code{nginx:latest} or \code{nginx}.}
}
\value{
An empty list.
}
\description{
Deletes a container image that is registered to your Amazon Lightsail
container service.
}
\section{Request syntax}{
\preformatted{svc$delete_container_image(
  serviceName = "string",
  image = "string"
)
}
}

\keyword{internal}
