% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_terminate_client_vpn_connections}
\alias{ec2_terminate_client_vpn_connections}
\title{Terminates active Client VPN endpoint connections}
\usage{
ec2_terminate_client_vpn_connections(ClientVpnEndpointId, ConnectionId,
  Username, DryRun)
}
\arguments{
\item{ClientVpnEndpointId}{[required] The ID of the Client VPN endpoint to which the client is connected.}

\item{ConnectionId}{The ID of the client connection to be terminated.}

\item{Username}{The name of the user who initiated the connection. Use this option to
terminate all active connections for the specified user. This option can
only be used if the user has established up to five connections.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\value{
A list with the following syntax:\preformatted{list(
  ClientVpnEndpointId = "string",
  Username = "string",
  ConnectionStatuses = list(
    list(
      ConnectionId = "string",
      PreviousStatus = list(
        Code = "active"|"failed-to-terminate"|"terminating"|"terminated",
        Message = "string"
      ),
      CurrentStatus = list(
        Code = "active"|"failed-to-terminate"|"terminating"|"terminated",
        Message = "string"
      )
    )
  )
)
}
}
\description{
Terminates active Client VPN endpoint connections. This action can be
used to terminate a specific client connection, or up to five
connections established by a specific user.
}
\section{Request syntax}{
\preformatted{svc$terminate_client_vpn_connections(
  ClientVpnEndpointId = "string",
  ConnectionId = "string",
  Username = "string",
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
