% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_create_container_service_deployment}
\alias{lightsail_create_container_service_deployment}
\title{Creates a deployment for your Amazon Lightsail container service}
\usage{
lightsail_create_container_service_deployment(serviceName, containers,
  publicEndpoint)
}
\arguments{
\item{serviceName}{[required] The name of the container service for which to create the deployment.}

\item{containers}{An object that describes the settings of the containers that will be
launched on the container service.}

\item{publicEndpoint}{An object that describes the settings of the public endpoint for the
container service.}
}
\description{
Creates a deployment for your Amazon Lightsail container service.

A deployment specifies the containers that will be launched on the
container service and their settings, such as the ports to open, the
environment variables to apply, and the launch command to run. It also
specifies the container that will serve as the public endpoint of the
deployment and its settings, such as the HTTP or HTTPS port to use, and
the health check configuration.

You can deploy containers to your container service using container
images from a public registry like Docker Hub, or from your local
machine. For more information, see Creating container images for your
Amazon Lightsail container services in the \emph{Lightsail Dev Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_container_service_deployment(
  serviceName = "string",
  containers = list(
    list(
      image = "string",
      command = list(
        "string"
      ),
      environment = list(
        "string"
      ),
      ports = list(
        "HTTP"|"HTTPS"|"TCP"|"UDP"
      )
    )
  ),
  publicEndpoint = list(
    containerName = "string",
    containerPort = 123,
    healthCheck = list(
      healthyThreshold = 123,
      unhealthyThreshold = 123,
      timeoutSeconds = 123,
      intervalSeconds = 123,
      path = "string",
      successCodes = "string"
    )
  )
)
}
}

\keyword{internal}
