% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_client_vpn_endpoint}
\alias{ec2_modify_client_vpn_endpoint}
\title{Modifies the specified Client VPN endpoint}
\usage{
ec2_modify_client_vpn_endpoint(ClientVpnEndpointId,
  ServerCertificateArn, ConnectionLogOptions, DnsServers, VpnPort,
  Description, SplitTunnel, DryRun, SecurityGroupIds, VpcId,
  SelfServicePortal, ClientConnectOptions)
}
\arguments{
\item{ClientVpnEndpointId}{[required] The ID of the Client VPN endpoint to modify.}

\item{ServerCertificateArn}{The ARN of the server certificate to be used. The server certificate
must be provisioned in AWS Certificate Manager (ACM).}

\item{ConnectionLogOptions}{Information about the client connection logging options.

If you enable client connection logging, data about client connections
is sent to a Cloudwatch Logs log stream. The following information is
logged:
\itemize{
\item Client connection requests
\item Client connection results (successful and unsuccessful)
\item Reasons for unsuccessful client connection requests
\item Client connection termination time
}}

\item{DnsServers}{Information about the DNS servers to be used by Client VPN connections.
A Client VPN endpoint can have up to two DNS servers.}

\item{VpnPort}{The port number to assign to the Client VPN endpoint for TCP and UDP
traffic.

Valid Values: \code{443} | \code{1194}

Default Value: \code{443}}

\item{Description}{A brief description of the Client VPN endpoint.}

\item{SplitTunnel}{Indicates whether the VPN is split-tunnel.

For information about split-tunnel VPN endpoints, see \href{https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html}{Split-Tunnel AWS Client VPN Endpoint}
in the \emph{AWS Client VPN Administrator Guide}.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{SecurityGroupIds}{The IDs of one or more security groups to apply to the target network.}

\item{VpcId}{The ID of the VPC to associate with the Client VPN endpoint.}

\item{SelfServicePortal}{Specify whether to enable the self-service portal for the Client VPN
endpoint.}

\item{ClientConnectOptions}{The options for managing connection authorization for new client
connections.}
}
\description{
Modifies the specified Client VPN endpoint. Modifying the DNS server
resets existing client connections.
}
\section{Request syntax}{
\preformatted{svc$modify_client_vpn_endpoint(
  ClientVpnEndpointId = "string",
  ServerCertificateArn = "string",
  ConnectionLogOptions = list(
    Enabled = TRUE|FALSE,
    CloudwatchLogGroup = "string",
    CloudwatchLogStream = "string"
  ),
  DnsServers = list(
    CustomDnsServers = list(
      "string"
    ),
    Enabled = TRUE|FALSE
  ),
  VpnPort = 123,
  Description = "string",
  SplitTunnel = TRUE|FALSE,
  DryRun = TRUE|FALSE,
  SecurityGroupIds = list(
    "string"
  ),
  VpcId = "string",
  SelfServicePortal = "enabled"|"disabled",
  ClientConnectOptions = list(
    Enabled = TRUE|FALSE,
    LambdaFunctionArn = "string"
  )
)
}
}

\keyword{internal}
