% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_disassociate_vpc_cidr_block}
\alias{ec2_disassociate_vpc_cidr_block}
\title{Disassociates a CIDR block from a VPC}
\usage{
ec2_disassociate_vpc_cidr_block(AssociationId)
}
\arguments{
\item{AssociationId}{[required] The association ID for the CIDR block.}
}
\description{
Disassociates a CIDR block from a VPC. To disassociate the CIDR block,
you must specify its association ID. You can get the association ID by
using DescribeVpcs. You must detach or delete all gateways and resources
that are associated with the CIDR block before you can disassociate it.

You cannot disassociate the CIDR block with which you originally created
the VPC (the primary CIDR block).
}
\section{Request syntax}{
\preformatted{svc$disassociate_vpc_cidr_block(
  AssociationId = "string"
)
}
}

\keyword{internal}
