% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_fleet}
\alias{ec2_create_fleet}
\title{Launches an EC2 Fleet}
\usage{
ec2_create_fleet(DryRun, ClientToken, SpotOptions, OnDemandOptions,
  ExcessCapacityTerminationPolicy, LaunchTemplateConfigs,
  TargetCapacitySpecification, TerminateInstancesWithExpiration, Type,
  ValidFrom, ValidUntil, ReplaceUnhealthyInstances, TagSpecifications)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{ClientToken}{Unique, case-sensitive identifier you provide to ensure the idempotency
of the request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{Ensuring Idempotency}.}

\item{SpotOptions}{Describes the configuration of Spot Instances in an EC2 Fleet.}

\item{OnDemandOptions}{The allocation strategy of On-Demand Instances in an EC2 Fleet.}

\item{ExcessCapacityTerminationPolicy}{Indicates whether running instances should be terminated if the total
target capacity of the EC2 Fleet is decreased below the current size of
the EC2 Fleet.}

\item{LaunchTemplateConfigs}{[required] The configuration for the EC2 Fleet.}

\item{TargetCapacitySpecification}{[required] The \code{TotalTargetCapacity}, \code{OnDemandTargetCapacity},
\code{SpotTargetCapacity}, and \code{DefaultCapacityType} structure.}

\item{TerminateInstancesWithExpiration}{Indicates whether running instances should be terminated when the EC2
Fleet expires.}

\item{Type}{The type of the request. By default, the EC2 Fleet places an
asynchronous request for your desired capacity, and maintains it by
replenishing interrupted Spot Instances (\code{maintain}). A value of
\code{instant} places a synchronous one-time request, and returns errors for
any instances that could not be launched. A value of \code{request} places an
asynchronous one-time request without maintaining capacity or submitting
requests in alternative capacity pools if capacity is unavailable. For
more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-configuration-strategies.html#ec2-fleet-request-type}{EC2 Fleet Request Types}
in the \emph{Amazon Elastic Compute Cloud User Guide}.}

\item{ValidFrom}{The start date and time of the request, in UTC format (for example,
\emph{YYYY}-\emph{MM}-\emph{DD}T\emph{HH}:\emph{MM}:\emph{SS}Z). The default is to start fulfilling
the request immediately.}

\item{ValidUntil}{The end date and time of the request, in UTC format (for example,
\emph{YYYY}-\emph{MM}-\emph{DD}T\emph{HH}:\emph{MM}:\emph{SS}Z). At this point, no new EC2 Fleet
requests are placed or able to fulfill the request. If no value is
specified, the request remains until you cancel it.}

\item{ReplaceUnhealthyInstances}{Indicates whether EC2 Fleet should replace unhealthy instances.}

\item{TagSpecifications}{The key-value pair for tagging the EC2 Fleet request on creation. The
value for \code{ResourceType} must be \code{fleet}, otherwise the fleet request
fails. To tag instances at launch, specify the tags in the \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template}{launch template}.
For information about tagging after launch, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources}{Tagging Your Resources}.}
}
\description{
Launches an EC2 Fleet.
}
\details{
You can create a single EC2 Fleet that includes multiple launch
specifications that vary by instance type, AMI, Availability Zone, or
subnet.

For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet.html}{Launching an EC2 Fleet}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_fleet(
  DryRun = TRUE|FALSE,
  ClientToken = "string",
  SpotOptions = list(
    AllocationStrategy = "lowest-price"|"diversified",
    InstanceInterruptionBehavior = "hibernate"|"stop"|"terminate",
    InstancePoolsToUseCount = 123,
    SingleInstanceType = TRUE|FALSE,
    SingleAvailabilityZone = TRUE|FALSE,
    MinTargetCapacity = 123
  ),
  OnDemandOptions = list(
    AllocationStrategy = "lowest-price"|"prioritized",
    SingleInstanceType = TRUE|FALSE,
    SingleAvailabilityZone = TRUE|FALSE,
    MinTargetCapacity = 123
  ),
  ExcessCapacityTerminationPolicy = "no-termination"|"termination",
  LaunchTemplateConfigs = list(
    list(
      LaunchTemplateSpecification = list(
        LaunchTemplateId = "string",
        LaunchTemplateName = "string",
        Version = "string"
      ),
      Overrides = list(
        list(
          InstanceType = "t1.micro"|"t2.nano"|"t2.micro"|"t2.small"|"t2.medium"|"t2.large"|"t2.xlarge"|"t2.2xlarge"|"t3.nano"|"t3.micro"|"t3.small"|"t3.medium"|"t3.large"|"t3.xlarge"|"t3.2xlarge"|"m1.small"|"m1.medium"|"m1.large"|"m1.xlarge"|"m3.medium"|"m3.large"|"m3.xlarge"|"m3.2xlarge"|"m4.large"|"m4.xlarge"|"m4.2xlarge"|"m4.4xlarge"|"m4.10xlarge"|"m4.16xlarge"|"m2.xlarge"|"m2.2xlarge"|"m2.4xlarge"|"cr1.8xlarge"|"r3.large"|"r3.xlarge"|"r3.2xlarge"|"r3.4xlarge"|"r3.8xlarge"|"r4.large"|"r4.xlarge"|"r4.2xlarge"|"r4.4xlarge"|"r4.8xlarge"|"r4.16xlarge"|"r5.large"|"r5.xlarge"|"r5.2xlarge"|"r5.4xlarge"|"r5.12xlarge"|"r5.24xlarge"|"r5.metal"|"r5a.large"|"r5a.xlarge"|"r5a.2xlarge"|"r5a.4xlarge"|"r5a.12xlarge"|"r5a.24xlarge"|"r5d.large"|"r5d.xlarge"|"r5d.2xlarge"|"r5d.4xlarge"|"r5d.12xlarge"|"r5d.24xlarge"|"r5d.metal"|"r5ad.large"|"r5ad.xlarge"|"r5ad.2xlarge"|"r5ad.4xlarge"|"r5ad.8xlarge"|"r5ad.12xlarge"|"r5ad.16xlarge"|"r5ad.24xlarge"|"x1.16xlarge"|"x1.32xlarge"|"x1e.xlarge"|"x1e.2xlarge"|"x1e.4xlarge"|"x1e.8xlarge"|"x1e.16xlarge"|"x1e.32xlarge"|"i2.xlarge"|"i2.2xlarge"|"i2.4xlarge"|"i2.8xlarge"|"i3.large"|"i3.xlarge"|"i3.2xlarge"|"i3.4xlarge"|"i3.8xlarge"|"i3.16xlarge"|"i3.metal"|"hi1.4xlarge"|"hs1.8xlarge"|"c1.medium"|"c1.xlarge"|"c3.large"|"c3.xlarge"|"c3.2xlarge"|"c3.4xlarge"|"c3.8xlarge"|"c4.large"|"c4.xlarge"|"c4.2xlarge"|"c4.4xlarge"|"c4.8xlarge"|"c5.large"|"c5.xlarge"|"c5.2xlarge"|"c5.4xlarge"|"c5.9xlarge"|"c5.18xlarge"|"c5d.large"|"c5d.xlarge"|"c5d.2xlarge"|"c5d.4xlarge"|"c5d.9xlarge"|"c5d.18xlarge"|"c5n.large"|"c5n.xlarge"|"c5n.2xlarge"|"c5n.4xlarge"|"c5n.9xlarge"|"c5n.18xlarge"|"cc1.4xlarge"|"cc2.8xlarge"|"g2.2xlarge"|"g2.8xlarge"|"g3.4xlarge"|"g3.8xlarge"|"g3.16xlarge"|"g3s.xlarge"|"cg1.4xlarge"|"p2.xlarge"|"p2.8xlarge"|"p2.16xlarge"|"p3.2xlarge"|"p3.8xlarge"|"p3.16xlarge"|"p3dn.24xlarge"|"d2.xlarge"|"d2.2xlarge"|"d2.4xlarge"|"d2.8xlarge"|"f1.2xlarge"|"f1.4xlarge"|"f1.16xlarge"|"m5.large"|"m5.xlarge"|"m5.2xlarge"|"m5.4xlarge"|"m5.12xlarge"|"m5.24xlarge"|"m5.metal"|"m5a.large"|"m5a.xlarge"|"m5a.2xlarge"|"m5a.4xlarge"|"m5a.12xlarge"|"m5a.24xlarge"|"m5d.large"|"m5d.xlarge"|"m5d.2xlarge"|"m5d.4xlarge"|"m5d.12xlarge"|"m5d.24xlarge"|"m5d.metal"|"m5ad.large"|"m5ad.xlarge"|"m5ad.2xlarge"|"m5ad.4xlarge"|"m5ad.8xlarge"|"m5ad.12xlarge"|"m5ad.16xlarge"|"m5ad.24xlarge"|"h1.2xlarge"|"h1.4xlarge"|"h1.8xlarge"|"h1.16xlarge"|"z1d.large"|"z1d.xlarge"|"z1d.2xlarge"|"z1d.3xlarge"|"z1d.6xlarge"|"z1d.12xlarge"|"z1d.metal"|"u-6tb1.metal"|"u-9tb1.metal"|"u-12tb1.metal"|"a1.medium"|"a1.large"|"a1.xlarge"|"a1.2xlarge"|"a1.4xlarge",
          MaxPrice = "string",
          SubnetId = "string",
          AvailabilityZone = "string",
          WeightedCapacity = 123.0,
          Priority = 123.0,
          Placement = list(
            AvailabilityZone = "string",
            Affinity = "string",
            GroupName = "string",
            PartitionNumber = 123,
            HostId = "string",
            Tenancy = "default"|"dedicated"|"host",
            SpreadDomain = "string"
          )
        )
      )
    )
  ),
  TargetCapacitySpecification = list(
    TotalTargetCapacity = 123,
    OnDemandTargetCapacity = 123,
    SpotTargetCapacity = 123,
    DefaultTargetCapacityType = "spot"|"on-demand"
  ),
  TerminateInstancesWithExpiration = TRUE|FALSE,
  Type = "request"|"maintain"|"instant",
  ValidFrom = as.POSIXct(
    "2015-01-01"
  ),
  ValidUntil = as.POSIXct(
    "2015-01-01"
  ),
  ReplaceUnhealthyInstances = TRUE|FALSE,
  TagSpecifications = list(
    list(
      ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"elastic-ip"|"fleet"|"fpga-image"|"host-reservation"|"image"|"instance"|"internet-gateway"|"launch-template"|"natgateway"|"network-acl"|"network-interface"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-instances-request"|"subnet"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway",
      Tags = list(
        list(
          Key = "string",
          Value = "string"
        )
      )
    )
  )
)
}
}

\keyword{internal}
