% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesisanalyticsv2_operations.R
\name{kinesisanalyticsv2_add_application_input_processing_configuration}
\alias{kinesisanalyticsv2_add_application_input_processing_configuration}
\title{Adds an InputProcessingConfiguration to a SQL-based Kinesis Data
Analytics application}
\usage{
kinesisanalyticsv2_add_application_input_processing_configuration(
  ApplicationName,
  CurrentApplicationVersionId,
  InputId,
  InputProcessingConfiguration
)
}
\arguments{
\item{ApplicationName}{[required] The name of the application to which you want to add the input
processing configuration.}

\item{CurrentApplicationVersionId}{[required] The version of the application to which you want to add the input
processing configuration. You can use the
\code{\link[=kinesisanalyticsv2_describe_application]{describe_application}}
operation to get the current application version. If the version
specified is not the current version, the
\code{ConcurrentModificationException} is returned.}

\item{InputId}{[required] The ID of the input configuration to add the input processing
configuration to. You can get a list of the input IDs for an application
using the
\code{\link[=kinesisanalyticsv2_describe_application]{describe_application}}
operation.}

\item{InputProcessingConfiguration}{[required] The InputProcessingConfiguration to add to the application.}
}
\description{
Adds an InputProcessingConfiguration to a SQL-based Kinesis Data Analytics application. An input processor pre-processes records on the input stream before the application's SQL code executes. Currently, the only input processor available is \href{https://docs.aws.amazon.com/lambda/}{Amazon Lambda}.

See \url{https://paws-r.github.io/docs/kinesisanalyticsv2/add_application_input_processing_configuration.html} for full documentation.
}
\keyword{internal}
