% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_list_crawls}
\alias{glue_list_crawls}
\title{Returns all the crawls of a specified crawler}
\usage{
glue_list_crawls(
  CrawlerName,
  MaxResults = NULL,
  Filters = NULL,
  NextToken = NULL
)
}
\arguments{
\item{CrawlerName}{[required] The name of the crawler whose runs you want to retrieve.}

\item{MaxResults}{The maximum number of results to return. The default is 20, and maximum
is 100.}

\item{Filters}{Filters the crawls by the criteria you specify in a list of
\code{CrawlsFilter} objects.}

\item{NextToken}{A continuation token, if this is a continuation call.}
}
\description{
Returns all the crawls of a specified crawler. Returns only the crawls that have occurred since the launch date of the crawler history feature, and only retains up to 12 months of crawls. Older crawls will not be returned.

See \url{https://paws-r.github.io/docs/glue/list_crawls.html} for full documentation.
}
\keyword{internal}
