% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/athena_operations.R
\name{athena_create_data_catalog}
\alias{athena_create_data_catalog}
\title{Creates (registers) a data catalog with the specified name and
properties}
\usage{
athena_create_data_catalog(
  Name,
  Type,
  Description = NULL,
  Parameters = NULL,
  Tags = NULL
)
}
\arguments{
\item{Name}{[required] The name of the data catalog to create. The catalog name must be unique
for the Amazon Web Services account and can use a maximum of 127
alphanumeric, underscore, at sign, or hyphen characters. The remainder
of the length constraint of 256 is reserved for use by Athena.}

\item{Type}{[required] The type of data catalog to create: \code{LAMBDA} for a federated catalog,
\code{HIVE} for an external hive metastore, or \code{GLUE} for an Glue Data
Catalog.}

\item{Description}{A description of the data catalog to be created.}

\item{Parameters}{Specifies the Lambda function or functions to use for creating the data
catalog. This is a mapping whose values depend on the catalog type.
\itemize{
\item For the \code{HIVE} data catalog type, use the following syntax. The
\verb{metadata-function} parameter is required. \verb{The sdk-version}
parameter is optional and defaults to the currently supported
version.

\verb{metadata-function=lambda_arn, sdk-version=version_number }
\item For the \code{LAMBDA} data catalog type, use one of the following sets of
required parameters, but not both.
\itemize{
\item If you have one Lambda function that processes metadata and
another for reading the actual data, use the following syntax.
Both parameters are required.

\verb{metadata-function=lambda_arn, record-function=lambda_arn }
\item If you have a composite Lambda function that processes both
metadata and data, use the following syntax to specify your
Lambda function.

\verb{function=lambda_arn }
}
\item The \code{GLUE} type takes a catalog ID parameter and is required. The
\code{catalog_id} is the account ID of the Amazon Web Services account
to which the Glue Data Catalog belongs.

\code{catalog-id=catalog_id }
\itemize{
\item The \code{GLUE} data catalog type also applies to the default
\code{AwsDataCatalog} that already exists in your account, of which
you can have only one and cannot modify.
\item Queries that specify a Glue Data Catalog other than the default
\code{AwsDataCatalog} must be run on Athena engine version 2.
\item In Regions where Athena engine version 2 is not available,
creating new Glue data catalogs results in an \code{INVALID_INPUT}
error.
}
}}

\item{Tags}{A list of comma separated tags to add to the data catalog that is
created.}
}
\description{
Creates (registers) a data catalog with the specified name and properties. Catalogs created are visible to all users of the same Amazon Web Services account.

See \url{https://paws-r.github.io/docs/athena/create_data_catalog.html} for full documentation.
}
\keyword{internal}
