% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datapipeline_operations.R
\name{datapipeline_report_task_progress}
\alias{datapipeline_report_task_progress}
\title{Task runners call ReportTaskProgress when assigned a task to acknowledge
that it has the task}
\usage{
datapipeline_report_task_progress(taskId, fields)
}
\arguments{
\item{taskId}{[required] The ID of the task assigned to the task runner. This value is provided
in the response for PollForTask.}

\item{fields}{Key-value pairs that define the properties of the
ReportTaskProgressInput object.}
}
\description{
Task runners call \code{ReportTaskProgress} when assigned a task to
acknowledge that it has the task. If the web service does not receive
this acknowledgement within 2 minutes, it assigns the task in a
subsequent PollForTask call. After this initial acknowledgement, the
task runner only needs to report progress every 15 minutes to maintain
its ownership of the task. You can change this reporting time from 15
minutes by specifying a \code{reportProgressTimeout} field in your pipeline.
}
\details{
If a task runner does not report its status after 5 minutes, AWS Data
Pipeline assumes that the task runner is unable to process the task and
reassigns the task in a subsequent response to PollForTask. Task runners
should call \code{ReportTaskProgress} every 60 seconds.
}
\section{Request syntax}{
\preformatted{svc$report_task_progress(
  taskId = "string",
  fields = list(
    list(
      key = "string",
      stringValue = "string",
      refValue = "string"
    )
  )
)
}
}

\keyword{internal}
