% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesis_operations.R
\name{kinesis_decrease_stream_retention_period}
\alias{kinesis_decrease_stream_retention_period}
\title{Decreases the Kinesis data stream's retention period, which is the
length of time data records are accessible after they are added to the
stream}
\usage{
kinesis_decrease_stream_retention_period(StreamName,
  RetentionPeriodHours)
}
\arguments{
\item{StreamName}{[required] The name of the stream to modify.}

\item{RetentionPeriodHours}{[required] The new retention period of the stream, in hours. Must be less than the
current retention period.}
}
\description{
Decreases the Kinesis data stream's retention period, which is the
length of time data records are accessible after they are added to the
stream. The minimum value of a stream's retention period is 24 hours.

This operation may result in lost data. For example, if the stream's
retention period is 48 hours and is decreased to 24 hours, any data
already in the stream that is older than 24 hours is inaccessible.
}
\section{Request syntax}{
\preformatted{svc$decrease_stream_retention_period(
  StreamName = "string",
  RetentionPeriodHours = 123
)
}
}

\keyword{internal}
