% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesisanalyticsv2_operations.R
\name{kinesisanalyticsv2_update_application}
\alias{kinesisanalyticsv2_update_application}
\title{Updates an existing Amazon Kinesis Data Analytics application}
\usage{
kinesisanalyticsv2_update_application(ApplicationName,
  CurrentApplicationVersionId, ApplicationConfigurationUpdate,
  ServiceExecutionRoleUpdate, RunConfigurationUpdate,
  CloudWatchLoggingOptionUpdates)
}
\arguments{
\item{ApplicationName}{[required] The name of the application to update.}

\item{CurrentApplicationVersionId}{[required] The current application version ID. You can retrieve the application
version ID using DescribeApplication.}

\item{ApplicationConfigurationUpdate}{Describes application configuration updates.}

\item{ServiceExecutionRoleUpdate}{Describes updates to the service execution role.}

\item{RunConfigurationUpdate}{Describes updates to the application's starting parameters.}

\item{CloudWatchLoggingOptionUpdates}{Describes application Amazon CloudWatch logging option updates. You can
only update existing CloudWatch logging options with this action. To add
a new CloudWatch logging option, use
AddApplicationCloudWatchLoggingOption.}
}
\description{
Updates an existing Amazon Kinesis Data Analytics application. Using
this operation, you can update application code, input configuration,
and output configuration.
}
\details{
Kinesis Data Analytics updates the \code{ApplicationVersionId} each time you
update your application.

SQL is not enabled for this private beta. Using SQL parameters (such as
SqlApplicationConfigurationUpdate) will result in an error.
}
\section{Request syntax}{
\preformatted{svc$update_application(
  ApplicationName = "string",
  CurrentApplicationVersionId = 123,
  ApplicationConfigurationUpdate = list(
    SqlApplicationConfigurationUpdate = list(
      InputUpdates = list(
        list(
          InputId = "string",
          NamePrefixUpdate = "string",
          InputProcessingConfigurationUpdate = list(
            InputLambdaProcessorUpdate = list(
              ResourceARNUpdate = "string"
            )
          ),
          KinesisStreamsInputUpdate = list(
            ResourceARNUpdate = "string"
          ),
          KinesisFirehoseInputUpdate = list(
            ResourceARNUpdate = "string"
          ),
          InputSchemaUpdate = list(
            RecordFormatUpdate = list(
              RecordFormatType = "JSON"|"CSV",
              MappingParameters = list(
                JSONMappingParameters = list(
                  RecordRowPath = "string"
                ),
                CSVMappingParameters = list(
                  RecordRowDelimiter = "string",
                  RecordColumnDelimiter = "string"
                )
              )
            ),
            RecordEncodingUpdate = "string",
            RecordColumnUpdates = list(
              list(
                Name = "string",
                Mapping = "string",
                SqlType = "string"
              )
            )
          ),
          InputParallelismUpdate = list(
            CountUpdate = 123
          )
        )
      ),
      OutputUpdates = list(
        list(
          OutputId = "string",
          NameUpdate = "string",
          KinesisStreamsOutputUpdate = list(
            ResourceARNUpdate = "string"
          ),
          KinesisFirehoseOutputUpdate = list(
            ResourceARNUpdate = "string"
          ),
          LambdaOutputUpdate = list(
            ResourceARNUpdate = "string"
          ),
          DestinationSchemaUpdate = list(
            RecordFormatType = "JSON"|"CSV"
          )
        )
      ),
      ReferenceDataSourceUpdates = list(
        list(
          ReferenceId = "string",
          TableNameUpdate = "string",
          S3ReferenceDataSourceUpdate = list(
            BucketARNUpdate = "string",
            FileKeyUpdate = "string"
          ),
          ReferenceSchemaUpdate = list(
            RecordFormat = list(
              RecordFormatType = "JSON"|"CSV",
              MappingParameters = list(
                JSONMappingParameters = list(
                  RecordRowPath = "string"
                ),
                CSVMappingParameters = list(
                  RecordRowDelimiter = "string",
                  RecordColumnDelimiter = "string"
                )
              )
            ),
            RecordEncoding = "string",
            RecordColumns = list(
              list(
                Name = "string",
                Mapping = "string",
                SqlType = "string"
              )
            )
          )
        )
      )
    ),
    ApplicationCodeConfigurationUpdate = list(
      CodeContentTypeUpdate = "PLAINTEXT"|"ZIPFILE",
      CodeContentUpdate = list(
        TextContentUpdate = "string",
        ZipFileContentUpdate = raw,
        S3ContentLocationUpdate = list(
          BucketARNUpdate = "string",
          FileKeyUpdate = "string",
          ObjectVersionUpdate = "string"
        )
      )
    ),
    FlinkApplicationConfigurationUpdate = list(
      CheckpointConfigurationUpdate = list(
        ConfigurationTypeUpdate = "DEFAULT"|"CUSTOM",
        CheckpointingEnabledUpdate = TRUE|FALSE,
        CheckpointIntervalUpdate = 123,
        MinPauseBetweenCheckpointsUpdate = 123
      ),
      MonitoringConfigurationUpdate = list(
        ConfigurationTypeUpdate = "DEFAULT"|"CUSTOM",
        MetricsLevelUpdate = "APPLICATION"|"TASK"|"OPERATOR"|"PARALLELISM",
        LogLevelUpdate = "INFO"|"WARN"|"ERROR"|"DEBUG"
      ),
      ParallelismConfigurationUpdate = list(
        ConfigurationTypeUpdate = "DEFAULT"|"CUSTOM",
        ParallelismUpdate = 123,
        ParallelismPerKPUUpdate = 123,
        AutoScalingEnabledUpdate = TRUE|FALSE
      )
    ),
    EnvironmentPropertyUpdates = list(
      PropertyGroups = list(
        list(
          PropertyGroupId = "string",
          PropertyMap = list(
            "string"
          )
        )
      )
    ),
    ApplicationSnapshotConfigurationUpdate = list(
      SnapshotsEnabledUpdate = TRUE|FALSE
    )
  ),
  ServiceExecutionRoleUpdate = "string",
  RunConfigurationUpdate = list(
    ApplicationRestoreConfiguration = list(
      ApplicationRestoreType = "SKIP_RESTORE_FROM_SNAPSHOT"|"RESTORE_FROM_LATEST_SNAPSHOT"|"RESTORE_FROM_CUSTOM_SNAPSHOT",
      SnapshotName = "string"
    )
  ),
  CloudWatchLoggingOptionUpdates = list(
    list(
      CloudWatchLoggingOptionId = "string",
      LogStreamARNUpdate = "string"
    )
  )
)
}
}

\keyword{internal}
