% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/summary.tcs.R
\name{summary.tcs}
\alias{summary.tcs}
\title{Tetracolorspace avian visual model summary}
\usage{
\method{summary}{tcs}(object, by = NULL, ...)
}
\arguments{
\item{object}{(required) Results of \code{tcs} or Can be either the result
from \code{\link{vismodel}} or independently calculated data (in the form of a data frame
with four columns, representing the avian cones).}

\item{by}{either a single value specifying the range of color points for which
summary colorspace variables should be calculated (for example, \code{by} = 3
indicates summary will be calculated for groups of 3 consecutive color points (rows)
in the quantum catch color data frame) or a vector containing identifications for
the rows in the quantum catch color data frame (in which case summaries will be
calculated for each group of points sharing the same identification). If \code{by}
is left blank, the summary statistics are calculated accross all color points in the
data.}

\item{...}{class consistency (ignored)}
}
\value{
a \code{data.frame} containing summary statistics with groups of points in rows and
the following variables in columns:

\code{centroid.u, .s, .m, .l} the centroids of \code{usml} coordinates of points

\code{c.vol} the total volume occupied by the points

\code{colspan.m} the mean hue span

\code{colspan.v} the variance in hue span

\code{mean.ra} mean saturation

\code{max.ra} maximum saturation achieved by the group of points
}
\description{
Calculates characteristics of a cloud of points (spectra) in avian tetrahedral color space
}
\examples{
\dontrun{
data(sicalis)
vis.sicalis <- vismodel(sicalis, visual='avg.uv')
tcs.sicalis <- tcs(vis.sicalis)
summary(tcs.sicalis, by=rep(c('C','T','B'),7))}
}
\author{
Rafael Maia \email{rm72@zips.uakron.edu}
}
\references{
Stoddard, M. C., & Prum, R. O. (2008). Evolution of avian plumage color in a tetrahedral color space: A phylogenetic analysis of new world buntings. The American Naturalist, 171(6), 755-776.

Endler, J. A., & Mielke, P. (2005). Comparing entire colour patterns as birds see them. Biological Journal Of The Linnean Society, 86(4), 405-431.
}

