% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_addReferenceLinesProfilePlot.R
\name{addReferenceLinesProfilePlot}
\alias{addReferenceLinesProfilePlot}
\title{Add reference lines to a profile plot}
\usage{
addReferenceLinesProfilePlot(
  gg,
  subjectVar = "USUBJID",
  refLines = NULL,
  refLinesData = NULL,
  refLinesTimeVar = NULL,
  refLinesLabelVar = NULL,
  refLinesColor = "black",
  refLinesLinetype = "dotted",
  timeLim = NULL,
  addLabel = FALSE
)
}
\arguments{
\item{gg}{\code{\link[ggplot2]{ggplot2}} with
a subject profile plot for a specific subject (and page)
(subset of the output of the \code{subjectProfile[X]Plot})}

\item{subjectVar}{String, variable of \code{data} with subject ID}

\item{refLines}{(optional) nested list with details for reference line(s).
Each sublist contains:
\itemize{
\item{(required) 'label': }{string with label for the reference line}
\item{(required) 'time': }{unique time (x) coordinate for the reference line}
\item{(optional) 'color': }{color for the reference line,
'black' by default}
\item{(optional) 'linetype': }{linetype for the reference line,
'dotted' by default}
}}

\item{refLinesData}{data.frame with data from which the reference line(s) should be extracted}

\item{refLinesTimeVar}{string, variable of \code{refLinesData} with time for reference line(s)}

\item{refLinesLabelVar}{string, variable of \code{refLinesData} with label for reference line(s)}

\item{refLinesColor}{vector of length 1 with default color for reference line(s)}

\item{refLinesLinetype}{vector of length 1 with default linetype for reference line(s)}

\item{timeLim}{vector of length 2 with time limits.
This is used to set the limits to the plot
containing the reference lines labels (if requested).}

\item{addLabel}{logical, if TRUE (FALSE by default) add the label of the reference line(s) at the bottom of the plot}
}
\value{
If \code{addLabel} is:
\itemize{ 
\item{\code{TRUE}: }{list with:
\itemize{
\item{'gg': }{\code{\link[ggplot2]{ggplot2}} plot with reference lines}
\item{'ggRefLines': }{\code{\link[ggplot2]{ggplot2}} plot containing only 
the labels at the specified position}
}}
\item{\code{FALSE}: }{\code{\link[ggplot2]{ggplot2}} plot with reference lines}
}
}
\description{
Add reference lines to a profile plot
}
\author{
Laure Cougnaud
}
