% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_chelsa.R
\name{download_chelsa}
\alias{download_chelsa}
\title{Download the CHELSA modern observations.}
\usage{
download_chelsa(var, res, path = NULL, version = "2.1", ...)
}
\arguments{
\item{var}{character Valid variables names are "tas", "tasmax","tasmin", and
"prec".}

\item{path}{character. Path where to download the data to. If left NULL, the data
will be downloaded from the directory returned by \code{\link[=get_data_path]{get_data_path()}}.}
}
\value{
TRUE if the requested CHELSA variable was downloaded successfully.
}
\description{
This function downloads monthly variables from the CHELSA 2.1 dataset.
These variables are saved in a format that can be read by
load_chelsa, and easily used for delta downscaling palaeoclimate
observations.
}
\details{
Note that variables are named differently from WorldClim. "tas" is the mean
temperature ("tavg" in WorldClim), with "tasmax" and "tasmin" being equivalent
to "tmax" and "tmin".
}
\keyword{internal}
