% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_iso8601.R
\name{parse_iso8601_helpers}
\alias{parse_iso8601_helpers}
\alias{is_iso8601_form}
\alias{is_iso8601_weekday}
\alias{is_iso8601_yearday}
\alias{is_iso8601_minfrac}
\alias{recalc_md_from_weekday}
\alias{recalc_md_from_yearday}
\alias{recalc_sec_from_minfrac}
\title{Inspecting and manipulating intermediate iso8601 matrices}
\usage{
is_iso8601_form(x, fields)

is_iso8601_weekday(x)

is_iso8601_yearday(x)

is_iso8601_minfrac(x)

recalc_md_from_weekday(x)

recalc_md_from_yearday(x)

recalc_sec_from_minfrac(x)
}
\arguments{
\item{x}{A \code{numeric} matrix of possible iso8601 fields}

\item{fields}{A \code{character} vector of fields}
}
\description{
An "iso8601 matrix" is a matrix of the various capture groups extraced from a
an iso8601 datetime string. These groups represent a superset of the fields
used by partial time objects, including representation for less common
datetime formats like yeardays, yearweeks or weekdays. Because the standard
provides a number of different combinations of fields that represent valid
strings, these functions serves to provide convenience functions for testing
or manipulating these less canonical representations.
}
\section{is_iso8601_* functions}{

Test whether rows of the matrix represent a specific form, as evident by
non-missing values in specific fields.
}

\section{recalc_* functions}{

Calculate canonical datetime fields from alternative representations
}

\keyword{internal}
