% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robust_estimation.R
\name{standard_error_robust}
\alias{standard_error_robust}
\title{Robust standard errors. Superseded by the \verb{vcov*} arguments in \code{standard_error()}}
\usage{
standard_error_robust(
  model,
  vcov = "HC3",
  vcov_args = NULL,
  component = "conditional",
  ...
)
}
\arguments{
\item{model}{A model.}

\item{vcov}{Variance-covariance matrix used to compute uncertainty estimates
(e.g., for robust standard errors). This argument accepts a covariance matrix,
a function which returns a covariance matrix, or a string which identifies
the function to be used to compute the covariance matrix.
\itemize{
\item A covariance matrix
\item A function which returns a covariance matrix (e.g., \code{stats::vcov()})
\item A string which indicates the kind of uncertainty estimates to return.
\itemize{
\item Heteroskedasticity-consistent: \code{"vcovHC"}, \code{"HC"}, \code{"HC0"}, \code{"HC1"},
\code{"HC2"}, \code{"HC3"}, \code{"HC4"}, \code{"HC4m"}, \code{"HC5"}. See \code{?sandwich::vcovHC}.
\item Cluster-robust: \code{"vcovCR"}, \code{"CR0"}, \code{"CR1"}, \code{"CR1p"}, \code{"CR1S"}, \code{"CR2"},
\code{"CR3"}. See \code{?clubSandwich::vcovCR}.
\item Bootstrap: \code{"vcovBS"}, \code{"xy"}, \code{"residual"}, \code{"wild"}, \code{"mammen"}, \code{"webb"}.
See \code{?sandwich::vcovBS}.
\item Other \code{sandwich} package functions: \code{"vcovHAC"}, \code{"vcovPC"}, \code{"vcovCL"}, \code{"vcovPL"}.
}
}}

\item{vcov_args}{List of arguments to be passed to the function identified by
the \code{vcov} argument. This function is typically supplied by the \strong{sandwich}
or \strong{clubSandwich} packages. Please refer to their documentation (e.g.,
\code{?sandwich::vcovHAC}) to see the list of available arguments.}

\item{component}{Model component for which standard errors should be shown.
See the documentation for your object's class in \code{\link[=model_parameters]{model_parameters()}} or
\code{\link[=p_value]{p_value()}} for further details.}

\item{...}{Arguments passed to or from other methods.}
}
\description{
Robust standard errors. Superseded by the \verb{vcov*} arguments in \code{standard_error()}
}
