% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apa6_formats.R
\name{apa6_pdf}
\alias{apa6_pdf}
\alias{apa6_docx}
\alias{apa6_word}
\alias{apa6_doc}
\title{APA manuscript (6th edition)}
\usage{
apa6_pdf(
  fig_caption = TRUE,
  number_sections = FALSE,
  toc = FALSE,
  keep_tex = TRUE,
  md_extensions = NULL,
  includes = NULL,
  ...
)

apa6_docx(
  fig_caption = TRUE,
  number_sections = FALSE,
  md_extensions = NULL,
  ...
)

apa6_word(...)

apa6_doc(...)
}
\arguments{
\item{fig_caption}{\code{TRUE} to render figures with captions}

\item{number_sections}{\code{TRUE} to number section headings}

\item{toc}{\code{TRUE} to include a table of contents in the output}

\item{keep_tex}{Keep the intermediate tex file used in the conversion to PDF}

\item{md_extensions}{Markdown extensions to be added or removed from the
default definition of R Markdown. See the
\code{\link[rmarkdown]{rmarkdown_format}} for additional details.}

\item{includes}{Named list of additional content to include within the
document (typically created using the \code{\link[rmarkdown]{includes}} function).}

\item{...}{Further arguments to pass to
\code{\link[bookdown]{pdf_document2}} or
\code{\link[bookdown]{word_document2}}.}
}
\value{
R Markdown output format to pass to \code{\link[rmarkdown:render]{rmarkdown::render()}}
}
\description{
Template for creating an article according to APA guidelines (6th edition)
in PDF or DOCX format.
}
\details{
When creating PDF documents the YAML option \code{classoption} is passed
to the class options of the LaTeX apa6 document class. In this case,
additional options are available. Refer to the \code{apa6} document class
\href{ftp://ftp.fu-berlin.de/tex/CTAN/macros/latex/contrib/apa6/apa6.pdf}{documentation}
to find out about class options such as paper size or draft watermarks.

Please refer to the \href{http://frederikaust.com/papaja_man/r-markdown-components.html#yaml-front-matter}{\pkg{papaja} online-manual}
for additional information on available YAML front matter settings.
Note that the available settings for DOCX documents are more limited
than for PDF documents.

When creating PDF documents the output device for figures defaults to
\code{c("pdf", "png")}, so that each figure is saved in all four formats
at a resolution of 300 dpi.
}
\section{Functions}{
\itemize{
\item \code{apa6_word}: Format to create .docx-files. Alias of \code{apa6_docx}.

\item \code{apa6_doc}: Format to create .docx-files. Alias of \code{apa6_docx}.
}}

\seealso{
\code{\link[bookdown:html_document2]{bookdown::pdf_document2()}}, \code{\link[bookdown:html_document2]{bookdown::word_document2()}}
}
