% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wb_data_prep.R
\name{make_wb_data}
\alias{make_wb_data}
\title{Prepare data for within-between modeling}
\usage{
make_wb_data(
  formula,
  data,
  id = NULL,
  wave = NULL,
  model = "w-b",
  detrend = FALSE,
  use.wave = FALSE,
  wave.factor = FALSE,
  min.waves = 2,
  balance.correction = FALSE,
  dt.random = TRUE,
  dt.order = 1,
  weights = NULL,
  offset = NULL,
  interaction.style = c("double-demean", "demean", "raw"),
  ...
)
}
\arguments{
\item{formula}{Model formula. See details for crucial
info on \code{panelr}'s formula syntax.}

\item{data}{The data, either a \code{panel_data} object or \code{data.frame}.}

\item{id}{If \code{data} is not a \code{panel_data} object, then the name of the
individual id column as a string. Otherwise, leave as NULL, the default.}

\item{wave}{If \code{data} is not a \code{panel_data} object, then the name of the
panel wave column as a string. Otherwise, leave as NULL, the default.}

\item{model}{One of \code{"w-b"}, \code{"within"}, \code{"between"},
\code{"contextual"}. See details for more on these options.}

\item{detrend}{Adjust within-subject effects for trends in the predictors?
Default is FALSE, but some research suggests this is a better idea
(see Curran and Bauer (2011) reference).}

\item{use.wave}{Should the wave be included as a predictor? Default is
FALSE.}

\item{wave.factor}{Should the wave variable be treated as an unordered
factor instead of continuous? Default is FALSE.}

\item{min.waves}{What is the minimum number of waves an individual must
have participated in to be included in the analysis? Default is \code{2} and
any valid number is accepted. \code{"all"} is also acceptable if you want to
include only complete panelists.}

\item{balance.correction}{Correct between-subject effects for unbalanced
panels following the procedure in Curran and Bauer (2011)? Default is
FALSE.}

\item{dt.random}{Should the detrending procedure be performed with a
random slope for each entity? Default is TRUE but for short panels
FALSE may be better, fitting a trend for all entities.}

\item{dt.order}{If detrending using \code{detrend}, what order polynomial
would you like to specify for the relationship between time and the
predictors? Default is 1, a linear model.}

\item{weights}{If using weights, either the name of the column in the data
that contains the weights or a vector of the weights.}

\item{offset}{this can be used to specify an \emph{a priori} known
    component to be included in the linear predictor during
    fitting. This should be \code{NULL} or a numeric vector of length
    equal to the number of cases.  One or more \code{\link{offset}}
    terms can be included in the formula instead or as well, and if more
    than one is specified their sum is used.  See \code{\link{model.offset}}.}

\item{interaction.style}{The best way to calculate interactions in within
models is in some dispute. The conventional way (\code{"demean"}) is to first
calculate the product of the variables involved in the interaction before
those variables have their means subtracted and then subtract the mean of
the product from the product term (see Schunk and Perales (2017)).
Giesselmann and Schmidt-Catran (2018) show this method carries
between-entity differences that within models are designed to model out.
They suggest an alternate method (\code{"double-demean"}) in which the product
term is first calculated using the de-meaned lower-order variables and
then the subject means are subtracted from this product term. Another
option is to simply use the product term of the de-meaned variables
(\code{"raw"}), but Giesselmann and Schmidt-Catran (2018) show this method
biases the results towards zero effect. The default is \code{"double-demean"}
but if emulating other software is the goal, \code{"demean"} might be
preferred.}

\item{...}{Additional arguments provided to \code{\link[lme4:lmer]{lme4::lmer()}},
\code{\link[lme4:glmer]{lme4::glmer()}}, or \code{\link[lme4:glmer.nb]{lme4::glmer.nb()}}.}
}
\value{
A \code{panel_data} object with the requested specification.
}
\description{
This function allows users to make the changes to their data
that occur in \code{\link[=wbm]{wbm()}} without having to fit the model.
}
\examples{

data("WageData")
wages <- panel_data(WageData, id = id, wave = t)
make_wb_data(lwage ~ wks + union | fem, data = wages)

}
