% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plotOccData.R
\name{plotOccData}
\alias{plotOccData}
\title{Plotting Occurrence Data Across Taxa}
\usage{
plotOccData(occList, groupLabel = NULL, occColors = NULL,
  lineWidth = NULL, xlims = NULL)
}
\arguments{
\item{occList}{A list where every element is a table of occurrence data for a different taxon,
such as that returned by \code{\link{taxonSortPBDBocc}}. The occurrence data can be either a
two-column matrix composed of the lower and upper age bounds on each taxon occurrence, or has
two named variables which match any of the field names given by the PBDB API under either
the 'pbdb' vocab or 'com' (compact) vocab for early and late age bounds.}

\item{groupLabel}{A character vector with a single string giving the name for
the occurrence dataset used, such as the taxonomic name of the group examined.
If not given (the default) a generic plot title is appended.}

\item{occColors}{A vector of numbers or characters indicating colors on a color
palette for use with basic plot. Must be the same length as occList. If empty, the
default, the colors used are sampled randomly from the \code{rainbow()} function.}

\item{lineWidth}{A numeric value giving the length to be used for the width of lines
plotted in \code{plotOccData}. If not given (the default), this is calculated using
an algorithm that selects an optimal line width for plotting.}

\item{xlims}{A two element vector controlling the width of the horizontal time-scale
the occurrence bars are plotted against. By default, this is not given and calculated
internally.}
}
\value{
This function will invisibly return a list, with each per-taxon element containing the
two-column matrix of age bounds for occurrences.
}
\description{
\code{plotOccData} takes occurrence data which has been sorted into a by-taxon list,
such as that output by \code{taxonSortPBDBocc} or may be output by simulations using
\code{sampleRanges} and produces a plot showing the age uncertainty associated with
individual occurrences, with occurrences of the same taxon grouped by color.
}
\details{
This function was originally conceived of in the following blog post:
\href{http://nemagraptus.blogspot.com/2015/02/how-do-we-treat-fossil-age-data-dates.html}{Link}
}
\examples{
#load example graptolite PBDB occ dataset
data(graptPBDB)

#get formal genera
occSpecies<-taxonSortPBDBocc(graptOccPBDB, rank="species")

#plot it!
plotOccData(occSpecies)

#this isn't too many occurrences, because there are so few
    #formal grapt species in the PBDB

#genera is messier...

#get formal genera
occGenus<-taxonSortPBDBocc(graptOccPBDB, rank="genus")

#plot it!
plotOccData(occGenus)

#some of those genera have occurrences with very large
   #age uncertainties on them!
}
\author{
David W. Bapst
}
\seealso{
\code{\link{taxonSortPBDBocc}}, \code{\link{occData2timeList}}
and the example graptolite dataset at \code{\link{graptPBDB}}
}

