% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SEA.R
\name{SEA}
\alias{SEA}
\title{Superposed Epoch Analysis}
\usage{
SEA(
  x,
  y,
  lag,
  b = NULL,
  conf = c(0.05, 0.95),
  nboot = 1000,
  center = FALSE,
  normalize = FALSE,
  age = "CE"
)
}
\arguments{
\item{x}{data frame or matrix with ages and proxy values, younger ages on top.}

\item{y}{events dates.}

\item{lag}{lag time used for calculating the SEA.}

\item{b}{A numeric giving block size, if NULL the optimal block size is given by: b= 2x(-1 /log(p)), where p is the lag one
autocorrelation coefficient of the serie (Adams, Mann & Ammann 2003).}

\item{conf}{confidence intervals for the block bootstrap procedure.}

\item{nboot}{number of bootstrap replicates.}

\item{center}{logical, center each epoch by substracting values to each epoch's mean (default = FALSE).}

\item{normalize}{logical, normalize each epoch by calculating Z-Score (default = FALSE, see Adams, Mann & Ammann 2003)}

\item{age}{type of ages used in x[,1] either "CE" for Common Era or "BP" for Before Present.}
}
\value{
\item{res}{A "pfCircular" object with estimated confidence intervals.}
}
\description{
The function performs a Superposed Epoch Analysis on a provided temporal serie. 
The function uses pfCircular function for the computation of 
the block bootstrap procedure. The function could be used on both dendrochronological 
data and other data expressed in CE ages as well on paleoecological series expressed in BP.
Proxy data and ages must be spaced evenly but not necessarily using 1 yr time steps.
}
\examples{
\dontrun{
## Generate some fake data
set.seed(1)
n <- 100 # number of data points
t <- seq(0,4*pi,,100)
a <- 3
b <- 2
c.unif <- runif(n)
amp <- 4

# generate data and calculate "y"
set.seed(1)
y1 <- a*sin(b*t)+c.unif*amp # add uniform error

# SEA applied to fake dendrochronological data in CE
plot(rev(seq(1901,2000,1)), y1, t="l", ylim=range(y1)*c(1.2))
y=c(1923,1948,1972,1995)
points(y,rep(0,length(y)))
x=data.frame(rev(seq(1901,2000,1)),value=y1)
lag=10

#Perform SEA
res=SEA(x, y, lag, b = NULL, conf = c(0.05, 0.95), nboot = 1000, age="CE")
plot(res,xlim=c(-10,10),xlab="lag",ylab="Composite mean")

# SEA applied to fake paleoecological data in BP
plot(seq(-50,49,1), y1, t="l", ylim=range(y1)*c(1.2),xlim=c(50,-50))
y=1950-c(1923,1948,1972,1995)
points(y,rep(0,length(y)))
x=data.frame(seq(-50,49,1),value=y1)
# Perform SEA
res=SEA(x, y, lag, b = NULL, conf = c(0.05, 0.95), nboot = 1000, age="BP")
plot(res,xlim=c(-10,10),xlab="lag",ylab="Composite mean")
}
}
\seealso{
\code{\link{pfCircular}}
}
\author{
O. Blarquez
}
