% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paleoDiv.R
\name{pdb.diff}
\alias{pdb.diff}
\title{Subtract one occurrence data.frame from another, for disentangling overlapping taxonomies or quantifying stem-lineage diversity.}
\usage{
pdb.diff(x, subtract, id_col = x$occurrence_no)
}
\arguments{
\item{x}{Occurrence data from which to subtract.}

\item{subtract}{Occurrence data frame or vector of occurrence numbers to subtract from x}

\item{id_col}{Vector or column of x containing id to be used for determining which values are also found in subtract or subtract$occurrence_no}
}
\value{
A data.frame() containing the difference between the two occurrence datasets, i.e. all entries that are in x but not in subtract.
}
\description{
Subtract one occurrence data.frame from another, for disentangling overlapping taxonomies or quantifying stem-lineage diversity.
}
\examples{
data(archosauria)
pdb.union(rbind(archosauria$Ankylosauria, archosauria$Stegosauria))->Eurypoda
pdb.diff(Eurypoda, subtract=archosauria$Stegosauria)
}
