% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trial.R
\name{pa_trial}
\alias{pa_trial}
\title{EXPERIMENTAL FUNCTION - Create an interpolated trial object from as-applied data}
\usage{
pa_trial(
  input,
  data.columns = NULL,
  data.units = NULL,
  grid = NULL,
  algorithm = c("none", "simple", "ritas"),
  var.label = "as.applied",
  boundary = NULL,
  smooth.method = c("none", "krige", "idw"),
  formula = NULL,
  out.units = NULL,
  conversion.factor = 1,
  na.to.zero = ifelse(algorithm == "ritas", TRUE, FALSE),
  cores = 1L,
  steps = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{input}{an sf object containing the as applied trial}

\item{data.columns}{When algorithm is \sQuote{simple},
this argument should be a vector of length one indicating which 
column contains the \sQuote{trial or as-applied} data. 
When algorithm is \sQuote{ritas}, an optional
named vector with the column names for the variables
\sQuote{trial, angle, swath,
distance}. If a an unnamed vector is supplied, the
vector is assumed to be in this order. The default is
NULL, in which case the function attempts to guess the
columns by using a dictionary of possible guesses.
The column indicating the \sQuote{trial} information is not guessed, 
as there are too many possible options 
(seeds, fertilizer, soil amendments, etc).}

\item{data.units}{When algorithm is \sQuote{simple},
should be a vector of length one indicating the units
of the trial column and the moisture column. Common
values would be \sQuote{c('kg N/ha', 'seeds/acre')}. When
algorithm is \sQuote{ritas}, an optional named vector
with strings representing units for the variables
\sQuote{trial, angle, swath,
distance}. If a an unnamed vector is supplied, the
vector is assumed to be in this order. A typical value
for this argument would be \sQuote{c(trial = 'kg N/ha',
 angle = 'degreeN',
width = 'ft', distance = 'ft')}. Please see
\link[units]{valid_udunits} for help with specifying
units. The default is NULL, in which case the function
attempts to guess the units according to the values of
the variable. The units of \sQuote{trial} are not guessed, 
as there are too many possible options (seeds, fertilizer, soil amendments, etc).}

\item{grid}{an sf object containing the prediction grid.
If the user is processing as-applied data coming from a
research trial (i.e. follows a trial design), the user
can pass the sf object containing the trial design
information to this argument.}

\item{algorithm}{algorithm used to generate the yield
object.}

\item{var.label}{optional string to name the final
product. Defaults to \sQuote{as.applied}.}

\item{boundary}{optional sf object representing the
field's outer boundary. If it not supplied, the
function attempts to generate a boundary from the
observed points.}

\item{smooth.method}{the smoothing method to be used. If
\sQuote{none}, no smoothing will be conducted. If
\sQuote{idw}, inverse distance weighted interpolation
will be conducted. If \sQuote{krige}, kriging will be
conducted.}

\item{formula}{formula defining the relationship between
the dependent and independent variables. If the
dependent variable is a linear function of the
coordinates, the formula can be \sQuote{z ~ X + Y}. If
the dependent variable is modeled only as a function of
the mean spatial process, the formula can be \sQuote{z
~ 1}. If no formula is supplied, it defaults to
\sQuote{z ~ 1}.}

\item{out.units}{units of the output after being multiplied by
the conversion factor. If conversion.factor is 1 and out.units
is NULL, out.units will default to the units of the trial input.}

\item{conversion.factor}{a conversion factor by which the 
input trial data will be multiplied. This is useful for 
cases in which the user wants the output in different units from 
the input. A trivial example is a fertilizer trial in which 
the fertilizer contained in the input is only 50% of the total mass. 
In this case, conversion.factor should be set to 0.5.}

\item{na.to.zero}{whether areas in which the trial applicator has not covered
should be assigned a value of zero. This is only effective when \sQuote{algorithm}
is \sQuote{ritas}. Defaults to TRUE when \sQuote{algorithm} is \sQuote{ritas}.}

\item{cores}{the number of cores used in the operation}

\item{steps}{whether to return the intermediate steps 
of the trial processing algorithm}

\item{verbose}{whether to print function progress.
\sQuote{FALSE or 0} will suppress details. \sQuote{TRUE
or 1} will print a progress bar. \sQuote{>1} will print
step by step messages.}

\item{...}{additional arguments to be passed
\link[gstat]{krige} and \link[gstat]{idw}}
}
\value{
an object of class trial
}
\description{
EXPERIMENTAL FUNCTION - Create an interpolated trial object from as-applied data
}
\details{
This function will follow the steps in the
  selected algorithm to produce a  map of as-applied trial from the raw
  data.
}
\examples{
\dontrun{
## tbd
}

}
\author{
Caio dos Santos and Fernando Miguez
}
