% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2dii.plot.R
\name{qplot_emission_intensity}
\alias{qplot_emission_intensity}
\title{Create a quick emission intensity plot}
\usage{
qplot_emission_intensity(data)
}
\arguments{
\item{data}{A data frame like the output of \code{prep_emission_intensity()}.}
}
\value{
An object of class "ggplot".
}
\description{
Compared to \code{\link[r2dii.plot:plot_emission_intensity]{plot_emission_intensity()}} this function:
\itemize{
\item is restricted to plotting future as 5 years from the start year,
\item outputs formatted labels, based on emission metric column,
\item outputs a title,
\item outputs formatted axis labels.
}
}
\examples{
# `data` must meet documented "Requirements"
data <- subset(sda, sector == "cement" & region == "global")

qplot_emission_intensity(data)
}
\seealso{
Other plotting functions: 
\code{\link{plot_emission_intensity}()},
\code{\link{plot_techmix}()},
\code{\link{plot_trajectory}()},
\code{\link{prep_emission_intensity}()},
\code{\link{prep_techmix}()},
\code{\link{prep_trajectory}()},
\code{\link{qplot_techmix}()},
\code{\link{qplot_trajectory}()},
\code{\link{recode_metric_techmix}()},
\code{\link{recode_metric_trajectory}()},
\code{\link{scale_colour_r2dii}()},
\code{\link{scale_colour_r2dii_sector}()},
\code{\link{scale_colour_r2dii_tech}()},
\code{\link{scale_fill_r2dii}()},
\code{\link{scale_fill_r2dii_sector}()},
\code{\link{scale_fill_r2dii_tech}()},
\code{\link{spell_out_technology}()},
\code{\link{theme_2dii}()},
\code{\link{to_title}()}
}
\concept{plotting functions}
