% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lifeduration.R
\name{pac_lifeduration}
\alias{pac_lifeduration}
\title{Package version life duration at specific Date or for a specific version}
\usage{
pac_lifeduration(
  pac,
  version = NULL,
  at = NULL,
  lib.loc = .libPaths(),
  repos = biocran_repos()
)
}
\arguments{
\item{pac}{character a package name.}

\item{version}{character package version, By default the newest version is taken. Default: NULL}

\item{at}{Date old version of package. Default: NULL}

\item{lib.loc}{character vector. Is omitted for non NULL version. Default: \code{.libPaths()}}

\item{repos}{character vector base URLs of the repositories to use. By default checking CRAN and newest Bioconductor. Default \code{pacs::biocran_repos()}}
}
\value{
\code{difftime}, number of days package version was the newest one.
}
\description{
using CRAN website to get a package life duration for certain version or at a specific Date.
}
\note{
Function will scrap two github CRAN mirror and CRAN URL. Works mainly with CRAN packages.
Please as a courtesy to the R CRAN, don't overload their server by constantly using this function.
Results are cached for 1 hour with \code{memoise} package, memory cache.
}
\examples{
\dontrun{
pac_lifeduration("memoise")
pac_lifeduration("dplyr", version = "0.8.0")
pac_lifeduration("dplyr", at = as.Date("2019-02-14"))
# For Bioconductor packages will work only for the newest per R version and installed packages.
pac_lifeduration("S4Vectors")
}
}
