% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.TrainedOwl}
\alias{plot.TrainedOwl}
\title{Plot results from cross-validation}
\usage{
\method{plot}{TrainedOwl}(
  x,
  measure = c("auto", "mse", "mae", "deviance", "auc", "misclass"),
  plot_min = TRUE,
  ci_alpha = 0.2,
  ci_border = FALSE,
  ci_col = lattice::trellis.par.get("superpose.line")$col,
  ...
)
}
\arguments{
\item{x}{an object of class \code{'TrainedOwl'}, typically from a call
to \code{\link[=trainOwl]{trainOwl()}}}

\item{measure}{any of the measures used in the call to \code{\link[=trainOwl]{trainOwl()}}. If
\code{measure = "auto"} then deviance will be used for binomial and multinomial
models, whilst mean-squared error will be used for Gaussian and Poisson
models.}

\item{plot_min}{whether to mark the location of the penalty corresponding
to the best prediction score}

\item{ci_alpha}{alpha (opacity) for fill in confidence limits}

\item{ci_border}{color (or flag to turn off and on) the border of the
confidence limits}

\item{ci_col}{color for border of confidence limits}

\item{...}{other arguments that are passed on to \code{\link[lattice:xyplot]{lattice::xyplot()}}}
}
\value{
An object of class \code{'trellis'} is returned and, if used
interactively, will most likely have its print function
\code{\link[lattice:print.trellis]{lattice::print.trellis()}}) invoked, which draws the plot on the
current display device.
}
\description{
Plot results from cross-validation
}
\examples{
# Cross-validation for a SLOPE binomial model
set.seed(123)
tune <- trainOwl(subset(mtcars, select = c("mpg", "drat", "wt")),
                 mtcars$hp,
                 q = c(0.1, 0.2),
                 number = 10)
plot(tune, ci_col = "salmon", col = "black")
}
\seealso{
\code{\link[=trainOwl]{trainOwl()}}, \code{\link[lattice:xyplot]{lattice::xyplot()}}, \code{\link[lattice:panel.xyplot]{lattice::panel.xyplot()}}
}
