% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outbreaker.R
\name{outbreaker}
\alias{outbreaker}
\title{outbreaker2: main function for reconstructing disease outbreaks}
\usage{
outbreaker(
  data = outbreaker_data(),
  config = create_config(),
  priors = custom_priors(),
  likelihoods = custom_likelihoods(),
  moves = custom_moves()
)
}
\arguments{
\item{data}{a list of named items containing input data as returned by
\code{\link{outbreaker_data}}}

\item{config}{a set of settings as returned by \code{\link{create_config}}}

\item{priors}{a set of log-prior functions as returned by
\code{\link{custom_priors}}}

\item{likelihoods}{a set of log-likelihood functions as returned by
\code{\link{custom_likelihoods}}}

\item{moves}{a set of movement functions as returned by
\code{\link{custom_moves}}}
}
\description{
The function \code{outbreaker} is the main function of the package. It runs
processes various inputs (data, configuration settings, custom priors,
likelihoods and movement functions) and explores the space of plausible
transmission trees of a densely sampled outbreaks.\cr
}
\details{
The emphasis of 'outbreaker2' is on modularity, which enables customisation
of priors, likelihoods and even movements of parameters and augmented data by
the user. This the dedicated vignette on this topic
\code{vignette("outbreaker2_custom")}.\cr
}
\examples{

## get data
data(fake_outbreak)
dat <- fake_outbreak

\dontrun{
## run outbreaker
out <- outbreaker(data = list(dna = dat$dna, dates = dat$onset, w_dens = dat$w),
config = list(n_iter = 2e4, sample_every = 200))
plot(out)
as.data.frame(out)

## run outbreaker, no DNA sequences
out2 <- outbreaker(data = list(dates = dat$onset, w_dens = w),
config = list(n_iter = 2e4, sample_every = 200))
plot(out2)
as.data.frame(out2)

}
}
\references{
Jombart T, Cori A, Didelot X, Cauchemez S, Fraser C and Ferguson
    N (2014).  Bayesian reconstruction of disease outbreaks by combining
    epidemiologic and genomic data. PLoS Computational Biology.
}
\seealso{
\code{\link{outbreaker_data}} to process input data, and
    \code{\link{create_config}} to process/set up parameters

\itemize{

\item \code{\link{outbreaker_data}}: function to process input data

\item \code{\link{create_config}}: function to create default and customise
configuration settings

\item \code{\link{custom_priors}}: function to specify customised prior
functions

\item \code{\link{custom_likelihoods}}: function to specify customised likelihoods
functions

\item \code{\link{custom_moves}}: function to create default and customise movement
functions

}
}
\author{
Thibaut Jombart (\email{thibautjombart@gmail.com})
}
