% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneInfo.R
\name{geneInfo}
\alias{geneInfo}
\title{Retrieve gene summary information.}
\usage{
geneInfo(gene)
}
\arguments{
\item{gene}{Character: an ENSEMBL gene identifier (e.g.ENSG00000169174) or gene name (e.g. PCSK9).}
}
\value{
Returns a data frame (tibble format) with the following data structure:

\enumerate{
\item id
\item symbol
\item bioType
\item description
\item chromosome
\item tss
\item start
\item end
\item fwdStrand
\item exons
}
}
\description{
This function takes a gene ENSEMBL id (e.g.ENSG00000169174) or a gene name (e.g.PCSK9) and returns a table containing details about
input genes , such as genomic location, gene structure and its BioType.
}
\examples{
\dontrun{
result <- geneInfo(gene="ENSG00000169174")
result <- geneInfo(gene="PCSK9")
}
}
