/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.util.version;

import fr.ird.osmose.Configuration;
import fr.ird.osmose.Osmose;
import fr.ird.osmose.util.logging.OLogger;
import fr.ird.osmose.util.version.AbstractVersion;
import fr.ird.osmose.util.version.Version3;
import fr.ird.osmose.util.version.Version3Update1;
import fr.ird.osmose.util.version.Version3Update2;
import java.util.Arrays;

public class VersionManager
extends OLogger {
    private final AbstractVersion v3 = new Version3();
    private final AbstractVersion v3u1 = new Version3Update1();
    private final AbstractVersion v3u2 = new Version3Update2();
    private final AbstractVersion[] VERSIONS = new AbstractVersion[]{this.v3, this.v3u1, this.v3u2};
    public final AbstractVersion OSMOSE_VERSION = this.v3u2;
    private AbstractVersion cfgVersion;
    private static final VersionManager versionManager = new VersionManager();

    public static VersionManager getInstance() {
        return versionManager;
    }

    protected VersionManager() {
        Arrays.sort(this.VERSIONS);
    }

    public void updateConfiguration() {
        this.cfgVersion = this.getConfigurationVersion();
        if (this.cfgVersion.compareTo(this.OSMOSE_VERSION) < 0) {
            this.info("Configuration version {0} is older than Osmose version {1}. Your configuration file will be automatically updated.", new Object[]{this.cfgVersion, this.OSMOSE_VERSION});
            for (AbstractVersion version : this.VERSIONS) {
                if (version.compareTo(this.OSMOSE_VERSION) > 0 || this.cfgVersion.compareTo(version) >= 0) continue;
                version.updateConfiguration();
                this.getConfiguration().refresh();
            }
        } else if (this.cfgVersion.compareTo(this.OSMOSE_VERSION) > 0) {
            this.info("Configuration version {0} is more recent than Osmose version {1}. Your configuration might not run correctly, you should get the latest Osmose version.", new Object[]{this.cfgVersion, this.OSMOSE_VERSION});
        } else {
            this.info("Configuration version {0} matches Osmose version {1}. Nothing to do.", new Object[]{this.cfgVersion, this.OSMOSE_VERSION});
        }
    }

    private AbstractVersion getConfigurationVersion() {
        if (!this.getConfiguration().isNull("osmose.version")) {
            try {
                String sversion = this.getConfiguration().getString("osmose.version");
                sversion = sversion.replaceAll("[^0-9\\s]", "").replaceAll(" +", " ").trim();
                String[] split = sversion.split(" ");
                int number = Integer.valueOf(split[0].trim());
                int update = 0;
                if (split.length >= 1) {
                    update = Integer.valueOf(split[1].trim());
                }
                for (AbstractVersion aversion : this.VERSIONS) {
                    if (aversion.getNumber() != number || aversion.getUpdate() != update) continue;
                    return aversion;
                }
            }
            catch (Exception ex) {
                this.error("Could not identify version of the configuration, check parameter osmose.version = " + this.getConfiguration().getString("osmose.version"), ex);
            }
        }
        return this.v3;
    }

    private Configuration getConfiguration() {
        return Osmose.getInstance().getConfiguration();
    }
}

