/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.stage;

import fr.ird.osmose.Configuration;
import fr.ird.osmose.Osmose;
import fr.ird.osmose.stage.IStage;

abstract class AbstractStage
implements IStage {
    private float[][] thresholds;
    private final String key;

    AbstractStage(String key) {
        this.key = key;
    }

    @Override
    public void init() {
        int i;
        int nSpec = this.getConfiguration().getNSpecies();
        int nPlnk = this.getConfiguration().getNPlankton();
        this.thresholds = new float[nSpec + nPlnk][];
        for (i = 0; i < nSpec; ++i) {
            int nStage = !this.getConfiguration().isNull(this.key + i) ? this.getConfiguration().getArrayString(this.key + i).length + 1 : 1;
            this.thresholds[i] = nStage > 1 ? this.getConfiguration().getArrayFloat(this.key + i) : new float[0];
        }
        for (i = 0; i < nPlnk; ++i) {
            this.thresholds[nSpec + i] = new float[0];
        }
    }

    @Override
    public int getNStage(int iSpecies) {
        return this.thresholds[iSpecies].length + 1;
    }

    @Override
    public float[] getThresholds(int iSpecies) {
        return this.thresholds[iSpecies];
    }

    Configuration getConfiguration() {
        return Osmose.getInstance().getConfiguration();
    }
}

