/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.output;

import fr.ird.osmose.output.AbstractOutput;

public class NSchoolOutput
extends AbstractOutput {
    private double[] nschool;

    public NSchoolOutput(int rank) {
        super(rank);
    }

    @Override
    public void initStep() {
    }

    @Override
    public void reset() {
        this.nschool = new double[this.getNSpecies()];
    }

    @Override
    public void update() {
        for (int iSpec = 0; iSpec < this.getNSpecies(); ++iSpec) {
            this.nschool[iSpec] = this.getSchoolSet().getSchools(this.getSpecies(iSpec)).size();
        }
    }

    @Override
    public void write(float time) {
        this.writeVariable(time, this.nschool);
    }

    @Override
    String getFilename() {
        StringBuilder filename = new StringBuilder(this.getConfiguration().getString("output.file.prefix"));
        filename.append("_nschool_Simu");
        filename.append(this.getRank());
        filename.append(".csv");
        return filename.toString();
    }

    @Override
    String getDescription() {
        return "Number of schools";
    }

    @Override
    String[] getHeaders() {
        String[] species = new String[this.getNSpecies()];
        for (int i = 0; i < species.length; ++i) {
            species[i] = this.getSimulation().getSpecies(i).getName();
        }
        return species;
    }
}

