/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.process;

import fr.ird.osmose.School;
import fr.ird.osmose.Species;
import fr.ird.osmose.process.AbstractProcess;
import fr.ird.osmose.util.timeseries.SingleTimeSeries;
import java.util.List;

public class ReproductionProcess
extends AbstractProcess {
    private double[][] seasonSpawning;
    private double[] sexRatio;
    private double[] alpha;
    private double[] seedingBiomass;
    private int yearMaxSeeding;

    public ReproductionProcess(int rank) {
        super(rank);
    }

    @Override
    public void init() {
        int i;
        int nSpecies = this.getNSpecies();
        this.sexRatio = new double[nSpecies];
        this.alpha = new double[nSpecies];
        this.seasonSpawning = new double[nSpecies][];
        for (i = 0; i < nSpecies; ++i) {
            if (!this.getConfiguration().isNull("reproduction.season.file.sp" + i)) {
                SingleTimeSeries ts = new SingleTimeSeries(this.getRank());
                ts.read(this.getConfiguration().getFile("reproduction.season.file.sp" + i));
                this.seasonSpawning[i] = ts.getValues();
                continue;
            }
            this.seasonSpawning[i] = new double[]{1.0 / (double)this.getConfiguration().getNStepYear()};
        }
        for (i = 0; i < nSpecies; ++i) {
            float sum = 0.0f;
            for (double d : this.seasonSpawning[i]) {
                sum = (float)((double)sum + d);
            }
            if (!(sum > 0.0f)) continue;
            this.sexRatio[i] = this.getConfiguration().getDouble("species.sexratio.sp" + i);
            this.alpha[i] = this.getConfiguration().getDouble("species.relativefecundity.sp" + i);
        }
        this.seedingBiomass = new double[this.getNSpecies()];
        for (i = 0; i < this.getNSpecies(); ++i) {
            this.seedingBiomass[i] = this.getConfiguration().getDouble("population.seeding.biomass.sp" + i);
        }
        this.yearMaxSeeding = 0;
        if (!this.getConfiguration().isNull("population.seeding.year.max")) {
            this.yearMaxSeeding = this.getConfiguration().getInt("population.seeding.year.max") * this.getConfiguration().getNStepYear();
        } else {
            for (i = 0; i < this.getNSpecies(); ++i) {
                this.yearMaxSeeding = Math.max(this.yearMaxSeeding, this.getSpecies(i).getLifespanDt());
            }
            this.warning("Did not find parameter population.seeding.year.max. Osmose set it to " + (float)this.yearMaxSeeding / (float)this.getConfiguration().getNStepYear() + " years, the lifespan of the longest-lived species.");
        }
    }

    @Override
    public void run() {
        for (int i = 0; i < this.getConfiguration().getNSpecies(); ++i) {
            double nEgg = 0.0;
            Species species = this.getSpecies(i);
            List<School> schools = this.getSchoolSet().getSchools(species);
            if (this.sexRatio[i] > 0.0 && this.alpha[i] > 0.0) {
                double SSB = 0.0;
                for (School school : schools) {
                    if (!(school.getLength() >= species.getSizeMaturity())) continue;
                    SSB += school.getInstantaneousBiomass();
                }
                if (this.getSimulation().getIndexTimeSimu() < this.yearMaxSeeding && SSB == 0.0) {
                    SSB = this.seedingBiomass[i];
                }
                double season = this.getSeason(this.getSimulation().getIndexTimeSimu(), species);
                nEgg = this.sexRatio[i] * this.alpha[i] * season * SSB * 1000000.0;
            }
            for (School school : schools) {
                school.incrementAge();
            }
            int nSchool = this.getConfiguration().getNSchool(i);
            if (nEgg == 0.0) continue;
            if (nEgg < (double)nSchool) {
                School school0 = new School(species, nEgg);
                this.getSchoolSet().add(school0);
                continue;
            }
            if (!(nEgg >= (double)nSchool)) continue;
            for (int s = 0; s < nSchool; ++s) {
                School school0 = new School(species, nEgg / (double)nSchool);
                this.getSchoolSet().add(school0);
            }
        }
    }

    private double getSeason(int iStepSimu, Species species) {
        int iSpec = species.getIndex();
        int length = this.seasonSpawning[iSpec].length;
        int iStep = length > this.getConfiguration().getNStepYear() ? iStepSimu : (length == 1 ? 0 : this.getSimulation().getIndexTimeYear());
        return this.seasonSpawning[iSpec][iStep];
    }
}

