/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.output;

import fr.ird.osmose.School;
import fr.ird.osmose.output.AbstractOutput;
import java.io.File;

public class MeanTrophicLevelOutput
extends AbstractOutput {
    private double[] meanTL;
    private double[] biomass;

    public MeanTrophicLevelOutput(int rank) {
        super(rank);
        this.getSimulation().requestPreyRecord();
    }

    @Override
    public void initStep() {
    }

    @Override
    public void reset() {
        this.meanTL = new double[this.getNSpecies()];
        this.biomass = new double[this.getNSpecies()];
    }

    @Override
    public void update() {
        for (School school : this.getSchoolSet().getAliveSchools()) {
            int i;
            if (!this.includeClassZero() && school.getAgeDt() < school.getSpecies().getAgeClassZero()) continue;
            int n = i = school.getSpeciesIndex();
            this.meanTL[n] = this.meanTL[n] + school.getInstantaneousBiomass() * (double)school.getTrophicLevel();
            int n2 = i;
            this.biomass[n2] = this.biomass[n2] + school.getInstantaneousBiomass();
        }
    }

    @Override
    public void write(float time) {
        for (int i = 0; i < this.getConfiguration().getNSpecies(); ++i) {
            this.meanTL[i] = this.biomass[i] > 0.0 ? (double)((float)(this.meanTL[i] / this.biomass[i])) : Double.NaN;
        }
        this.writeVariable(time, this.meanTL);
    }

    @Override
    String getFilename() {
        StringBuilder filename = new StringBuilder("Trophic");
        filename.append(File.separatorChar);
        filename.append(this.getConfiguration().getString("output.file.prefix"));
        filename.append("_meanTL_Simu");
        filename.append(this.getRank());
        filename.append(".csv");
        return filename.toString();
    }

    @Override
    String getDescription() {
        StringBuilder str = new StringBuilder("Mean Trophic Level of fish species, weighted by fish biomass, and ");
        if (this.includeClassZero()) {
            str.append("including ");
        } else {
            str.append("excluding ");
        }
        str.append("first ages specified in input");
        return str.toString();
    }

    @Override
    String[] getHeaders() {
        String[] species = new String[this.getNSpecies()];
        for (int i = 0; i < species.length; ++i) {
            species[i] = this.getSimulation().getSpecies(i).getName();
        }
        return species;
    }
}

