% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osmapi_gps_traces.R
\name{osm_get_data_gpx}
\alias{osm_get_data_gpx}
\title{Download GPS Track Data}
\usage{
osm_get_data_gpx(gpx_id, format)
}
\arguments{
\item{gpx_id}{The track id represented by a numeric or a character value.}

\item{format}{Format of the output. If missing (default), the response will be the exact file that was uploaded.
If \code{"R"}, a \code{data.frame}.
If \code{"gpx"}, the response will always be a GPX format file.
If \code{"xml"}, a \code{"xml"} file in an undocumented format.}
}
\value{
If missing \code{format}, returns a \link[xml2:oldclass]{xml2::xml_document} with the original file data. If \code{format = "R"}, returns a
data frame with one point per row. If \code{format = "gpx"}, returns a \link[xml2:oldclass]{xml2::xml_document} in the GPX format. If
\code{format = "xml"}, returns a \link[xml2:oldclass]{xml2::xml_document} in an undocumented format.
}
\description{
Use this to download the full GPX file. Available without authentication if the file is marked public. Otherwise only
usable by the owner account and requires authentication.
}
\note{
If you request refers to a multi-file archive the response when you force gpx or xml format will consist of a
non-standard simple concatenation of the files.
}
\examples{
\dontrun{
trk_data <- osm_get_data_gpx(gpx_id = 3498170, format = "R")
trk_data
}
}
\seealso{
Other get GPS' functions: 
\code{\link{osm_get_gpx_metadata}()},
\code{\link{osm_get_points_gps}()},
\code{\link{osm_list_gpxs}()}
}
\concept{get GPS' functions}
