% Generated by roxygen2 (4.0.2): do not edit by hand
\name{ore}
\alias{is.ore}
\alias{ore}
\alias{print.ore}
\title{Oniguruma regular expressions}
\usage{
ore(pattern, options = "", encoding = "auto")

is.ore(x)

\method{print}{ore}(x, ...)
}
\arguments{
\item{pattern}{A single string representing the pattern describing a valid
regular expression. Note that backslashes should be doubled, to avoid
them being interpreted as character escapes by R.}

\item{options}{A string composed of characters indicating variations on the
usual interpretation of the regex. These may currently include \code{"i"}
for case-insensitive matching, and \code{"m"} for multiline matching (in
which case \code{"."} matches the newline character).}

\item{encoding}{The encoding that matching will take place in, a string
string naming one of the encoding types discussed in
\code{\link{Encoding}}, or \code{"auto"}. In the latter case, the encoding
of \code{pattern} will be used.}

\item{x}{An R object.}

\item{...}{Ignored.}
}
\value{
The \code{ore} function returns (the first element of)
  \code{pattern}, with class \code{"ore"} and the following attributes:
    \item{.compiled}{A low-level pointer to the compiled version of the
      regular expresion.}
    \item{options}{Options, copied from the argument of the same name.}
    \item{encoding}{The specified or detected encoding.}
  The \code{is.ore} function returns a logical vector indicating whether
  its argument represents an \code{"ore"} object.
}
\description{
Create, test for, and print objects of class \code{"ore"}, which represent
Oniguruma regular expressions. These are length-1 character vectors with
additional attributes, including a pointer to the compiled version.
}
\examples{
# This matches a positive or negative integer
ore("-?\\\\d+")

# This matches words of exactly four characters
ore("\\\\b\\\\w{4}\\\\b")
}
\seealso{
For full details of supported syntax, please see
\url{https://raw.githubusercontent.com/k-takata/Onigmo/master/doc/RE}. The
\code{\link{regex}} page is also useful as a quick reference, since PCRE
(used by base R) and Oniguruma (used by \code{ore}) have similar features.
}

