% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-stats-princomp.r
\name{methods-princomp}
\alias{methods-princomp}
\alias{as_tbl_ord.princomp}
\alias{recover_rows.princomp}
\alias{recover_cols.princomp}
\alias{recover_inertia.princomp}
\alias{recover_coord.princomp}
\alias{recover_conference.princomp}
\alias{recover_aug_rows.princomp}
\alias{recover_aug_cols.princomp}
\alias{recover_aug_coord.princomp}
\title{Functionality for principal components analysis ('princomp') objects}
\usage{
\method{as_tbl_ord}{princomp}(x)

\method{recover_rows}{princomp}(x)

\method{recover_cols}{princomp}(x)

\method{recover_inertia}{princomp}(x)

\method{recover_coord}{princomp}(x)

\method{recover_conference}{princomp}(x)

\method{recover_aug_rows}{princomp}(x)

\method{recover_aug_cols}{princomp}(x)

\method{recover_aug_coord}{princomp}(x)
}
\arguments{
\item{x}{An ordination object.}
}
\value{
The recovery generics \verb{recover_*()} return \link[=recoverers]{core model components}, \link[=conference]{distribution of inertia},
\link[=supplementation]{supplementary elements}, and \link[=augmentation]{intrinsic metadata}; but they require methods for each model class to
tell them what these components are.

The generic \code{\link[=as_tbl_ord]{as_tbl_ord()}} returns its input wrapped in the 'tbl_ord'
class. Its methods determine what model classes it is allowed to wrap. It
then provides 'tbl_ord' methods with access to the recoverers and hence to
the model components.
}
\description{
These methods extract data from, and attribute new data to,
objects of class \code{"princomp"} as returned by \code{\link[stats:princomp]{stats::princomp()}}.
}
\examples{
# data frame of Anderson iris species measurements
class(iris)
head(iris)

# compute unscaled row-principal components of scaled measurements
iris[, -5] \%>\%
  princomp() \%>\%
  as_tbl_ord() \%>\%
  print() -> iris_pca

# recover observation principal coordinates and measurement standard coordinates
head(get_rows(iris_pca))
get_cols(iris_pca)

# augment measurement coordinates with names and scaling parameters
(iris_pca <- augment_ord(iris_pca))
}
\seealso{
Other methods for singular value decomposition-based techniques: 
\code{\link{methods-cancor}},
\code{\link{methods-correspondence}},
\code{\link{methods-lda}},
\code{\link{methods-lra}},
\code{\link{methods-mca}},
\code{\link{methods-prcomp}},
\code{\link{methods-svd}}

Other models from the stats package: 
\code{\link{methods-cancor}},
\code{\link{methods-cmds}},
\code{\link{methods-factanal}},
\code{\link{methods-kmeans}},
\code{\link{methods-lm}},
\code{\link{methods-prcomp}}
}
\author{
Emily Paul
}
\concept{methods for singular value decomposition-based techniques}
\concept{models from the stats package}
